/*
 * Decompiled with CFR 0.152.
 */
package top.realme.mc.homohttprouter.http;

import com.alibaba.fastjson2.JSON;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import top.realme.mc.homohttprouter.http.RestRequest;
import top.realme.mc.homohttprouter.http.RestResponse;
import top.realme.mc.homohttprouter.http.RouteInfo;
import top.realme.mc.homohttprouter.http.RouterHandler;
import top.realme.mc.homohttprouter.http.RouterRegistry;

class HttpServerHandler
extends SimpleChannelInboundHandler<FullHttpRequest> {
    private final RouterRegistry registry;

    public HttpServerHandler(RouterRegistry registry) {
        this.registry = registry;
    }

    protected void channelRead0(ChannelHandlerContext ctx, FullHttpRequest req) {
        RestResponse restResp;
        String uri;
        String path = uri = req.uri();
        String query = "";
        int idx = uri.indexOf(63);
        if (idx >= 0) {
            path = uri.substring(0, idx);
            query = uri.substring(idx + 1);
        }
        byte[] bodyBytes = new byte[req.content().readableBytes()];
        req.content().readBytes(bodyBytes);
        HashMap<String, String> headers = new HashMap<String, String>();
        req.headers().forEach(h -> headers.put((String)h.getKey(), (String)h.getValue()));
        RestRequest restReq = new RestRequest(req.method().name(), path, query, headers, bodyBytes);
        if (path.equals("/docs.json")) {
            restResp = this.buildDocsJson();
        } else if (path.equals("/docs")) {
            restResp = this.buildDocsHtml();
        } else {
            RouterHandler handler = this.registry.findHandler(path);
            if (handler == null) {
                restResp = new RestResponse(404, "Not Found".getBytes());
                restResp.header("Content-Type", "text/plain");
            } else {
                try {
                    restResp = handler.handle(restReq);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    restResp = new RestResponse(500, e.toString().getBytes());
                    restResp.header("Content-Type", "text/plain");
                }
            }
        }
        this.send(ctx, restResp);
    }

    private void send(ChannelHandlerContext ctx, RestResponse resp) {
        DefaultFullHttpResponse nettyResp = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.valueOf((int)resp.status), Unpooled.wrappedBuffer((byte[])resp.body));
        resp.headers.forEach((arg_0, arg_1) -> HttpServerHandler.lambda$send$1((FullHttpResponse)nettyResp, arg_0, arg_1));
        nettyResp.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, resp.body.length);
        ctx.writeAndFlush((Object)nettyResp).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private RestResponse buildDocsJson() {
        HashMap<String, List<RouteInfo>> map = new HashMap<String, List<RouteInfo>>();
        map.put("routes", this.registry.listAll());
        byte[] json = JSON.toJSONString(map).getBytes(StandardCharsets.UTF_8);
        RestResponse r = new RestResponse(200, json);
        r.header("Content-Type", "application/json");
        return r;
    }

    private RestResponse buildDocsHtml() {
        StringBuilder sb = new StringBuilder();
        sb.append("<html><body>");
        sb.append("<h1>HomoHttpRouter API Docs</h1>");
        for (RouteInfo info : this.registry.listAll()) {
            sb.append("<h2>").append(info.prefix()).append(" \u2014 ").append(info.modId()).append("</h2>");
            sb.append("<p>").append(info.description()).append("</p>");
            for (RouteInfo.Endpoint ep : info.endpoints()) {
                sb.append("<div style='border:1px solid #aaa;padding:10px;margin:5px;'>");
                sb.append("<b>").append(ep.method()).append("</b> ");
                sb.append("<code>").append(info.prefix()).append(ep.path()).append("</code>");
                sb.append("<p>").append(ep.summary()).append("</p>");
                sb.append("</div>");
            }
        }
        sb.append("</body></html>");
        byte[] html = sb.toString().getBytes(StandardCharsets.UTF_8);
        RestResponse r = new RestResponse(200, html);
        r.header("Content-Type", "text/html; charset=utf-8");
        return r;
    }

    private static /* synthetic */ void lambda$send$1(FullHttpResponse nettyResp, String k, String v) {
        nettyResp.headers().add(k, (Object)v);
    }
}

