/*
 * Decompiled with CFR 0.152.
 */
package top.realme.mc.homohttprouter.http;

import com.mojang.logging.LogUtils;
import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import org.slf4j.Logger;
import top.realme.mc.homohttprouter.http.HttpServerInitializer;
import top.realme.mc.homohttprouter.http.RouterRegistry;

public class HttpServerManager {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final int port;
    private final RouterRegistry registry;
    private EventLoopGroup boss;
    private EventLoopGroup worker;
    private Channel serverChannel;

    public HttpServerManager(int port, RouterRegistry registry) {
        this.port = port;
        this.registry = registry;
    }

    public void start() {
        this.boss = new NioEventLoopGroup(1);
        this.worker = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)b.group(this.boss, this.worker).channel(NioServerSocketChannel.class)).childHandler((ChannelHandler)new HttpServerInitializer(this.registry));
        try {
            this.serverChannel = b.bind(this.port).sync().channel();
            LOGGER.info("Netty HTTP server started at http://localhost:{}/", (Object)this.port);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to start Netty HTTP server", e);
        }
    }

    public void stop() {
        try {
            if (this.serverChannel != null) {
                this.serverChannel.close().sync();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.boss != null) {
            this.boss.shutdownGracefully();
        }
        if (this.worker != null) {
            this.worker.shutdownGracefully();
        }
        LOGGER.info("Netty HTTP server stopped");
    }
}

