/*
 * Decompiled with CFR 0.152.
 */
package top.realme.mc.homohttprouter.http;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import top.realme.mc.homohttprouter.http.RouteInfo;
import top.realme.mc.homohttprouter.http.RouterHandler;

public class RouterRegistry {
    private final Map<String, Entry> routes = new HashMap<String, Entry>();

    public synchronized void register(RouteInfo info, RouterHandler handler) {
        if (this.routes.containsKey(info.prefix())) {
            throw new RuntimeException("Duplicate prefix: " + info.prefix());
        }
        this.routes.put(info.prefix(), new Entry(info.modId(), handler, info));
    }

    public synchronized RouterHandler findHandler(String path) {
        return this.routes.entrySet().stream().filter(e -> path.startsWith((String)e.getKey())).sorted((a, b) -> ((String)b.getKey()).length() - ((String)a.getKey()).length()).map(e -> ((Entry)e.getValue()).handler).findFirst().orElse(null);
    }

    public synchronized List<RouteInfo> listAll() {
        return this.routes.values().stream().map(e -> e.info).collect(Collectors.toList());
    }

    private static class Entry {
        final String modId;
        final RouterHandler handler;
        final RouteInfo info;

        Entry(String modId, RouterHandler handler, RouteInfo info) {
            this.modId = modId;
            this.handler = handler;
            this.info = info;
        }
    }
}

