/*
 * Decompiled with CFR 0.152.
 */
package ru.infikot.f3up;

import com.google.gson.JsonSyntaxException;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.concurrent.CompletableFuture;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_11631;
import net.minecraft.class_11644;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import ru.infikot.f3up.config.Config;
import ru.infikot.f3up.config.ConfigManager;
import ru.infikot.f3up.hud.PlaceholderProcessor;

public class F3UpMain
implements ClientModInitializer {
    public static Config CONFIG;
    private static final ConfigManager CONFIG_MANAGER;
    public static final PlaceholderProcessor PLACEHOLDER_PROCESSOR;
    private static final Pattern PLACEHOLDER_PATTERN;
    public static final String MOD_ID = "f3up";
    public static final long MOD_INIT_TIME;

    public void onInitializeClient() {
        System.out.println("F3Up: Initializing...");
        CONFIG_MANAGER.initialLoad();
        CONFIG = CONFIG_MANAGER.getConfig();
        F3UpMain.registerCustomEntries();
        this.registerCommands();
    }

    public static void registerCustomEntries() {
        if (CONFIG == null || CONFIG.entries() == null) {
            return;
        }
        CONFIG.entries().stream().filter(entry -> !entry.id().contains(":") || entry.id().startsWith("f3up:")).forEach(entry -> {
            class_2960 id = class_2960.method_12829((String)(entry.id().contains(":") ? entry.id() : "f3up:" + entry.id()));
            if (id != null) {
                class_11631.method_72763((class_2960)id, (lines, world, clientChunk, chunk) -> {});
            }
        });
    }

    public static void reloadConfig(FabricClientCommandSource source) {
        try {
            Config newConfig;
            CONFIG = newConfig = CONFIG_MANAGER.loadConfig();
            F3UpMain.registerCustomEntries();
            source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.reload.success"));
            class_310 client = source.getClient();
            if (client.field_1755 instanceof class_11644) {
                client.field_1755.method_25423(client, client.method_22683().method_4486(), client.method_22683().method_4502());
            }
        }
        catch (JsonSyntaxException e) {
            source.sendError((class_2561)class_2561.method_43471((String)"f3up.command.reload.json_error.header"));
            source.sendError((class_2561)class_2561.method_43471((String)"f3up.command.reload.json_error.body"));
            source.sendError((class_2561)class_2561.method_43470((String)e.getMessage()).method_27692(class_124.field_1054));
        }
        catch (IOException e) {
            source.sendError((class_2561)class_2561.method_43471((String)"f3up.command.reload.fail"));
            e.printStackTrace();
        }
    }

    private void registerCommands() {
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)MOD_ID).executes(context -> {
            F3UpMain.showHelp((FabricClientCommandSource)context.getSource());
            return 1;
        })).then(ClientCommandManager.literal((String)"reload").executes(context -> {
            F3UpMain.reloadConfig((FabricClientCommandSource)context.getSource());
            return 1;
        }))).then(ClientCommandManager.literal((String)"open").executes(context -> {
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            try {
                File configFile = ConfigManager.getConfigFile();
                class_156.method_668().method_672(configFile);
                source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.open.success"));
            }
            catch (Exception e) {
                e.printStackTrace();
                source.sendError((class_2561)class_2561.method_43471((String)"f3up.command.open.fail"));
                return 0;
            }
            return 1;
        }))).then(ClientCommandManager.literal((String)"list").executes(context -> {
            long vanillaCount = CONFIG.entries().stream().filter(e -> e.id().contains(":") && !e.id().startsWith("f3up:")).count();
            long customCount = CONFIG.entries().stream().filter(e -> !e.id().contains(":") || e.id().startsWith("f3up:")).count();
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.list.header").method_27692(class_124.field_1065));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"f3up.command.list.vanilla", (Object[])new Object[]{vanillaCount}));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"f3up.command.list.custom", (Object[])new Object[]{customCount}));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"f3up.command.list.total", (Object[])new Object[]{CONFIG.entries().size()}));
            return 1;
        }))).then(ClientCommandManager.literal((String)"version").executes(context -> {
            String version = ((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get()).getMetadata().getVersion().getFriendlyString();
            ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)class_2561.method_43469((String)"f3up.command.version", (Object[])new Object[]{version}));
            return 1;
        }))).then(ClientCommandManager.literal((String)"info").then(ClientCommandManager.argument((String)"id", (ArgumentType)StringArgumentType.greedyString()).suggests(F3UpMain::getModuleSuggestions).executes(context -> {
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            Config.ConfigEntry foundEntry = CONFIG.entries().stream().filter(e -> {
                Object entryId = e.id().contains(":") ? e.id() : "f3up:" + e.id();
                return ((String)entryId).equals(id);
            }).findFirst().orElse(null);
            FabricClientCommandSource source = (FabricClientCommandSource)context.getSource();
            if (foundEntry == null) {
                source.sendError((class_2561)class_2561.method_43469((String)"f3up.command.info.not_found", (Object[])new Object[]{id}));
                return 0;
            }
            HashSet placeholders = new HashSet();
            foundEntry.lines().forEach(line -> {
                Matcher matcher = PLACEHOLDER_PATTERN.matcher((CharSequence)line);
                while (matcher.find()) {
                    placeholders.add(matcher.group(0));
                }
            });
            source.sendFeedback((class_2561)class_2561.method_43469((String)"f3up.command.info.header", (Object[])new Object[]{foundEntry.menu_name()}).method_27692(class_124.field_1065));
            class_5250 status = class_2561.method_43471((String)(foundEntry.enabled() ? "f3up.command.info.status.enabled" : "f3up.command.info.status.disabled"));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"f3up.command.info.status", (Object[])new Object[]{status}));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7eSide: \u00a7f" + foundEntry.side())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7eOrder: \u00a7f" + foundEntry.order())));
            source.sendFeedback((class_2561)class_2561.method_43470((String)("\u00a7eCategory: \u00a7f" + foundEntry.category())));
            source.sendFeedback((class_2561)class_2561.method_43469((String)"f3up.command.info.lines_header", (Object[])new Object[]{foundEntry.lines().size()}).method_27692(class_124.field_1054));
            foundEntry.lines().forEach(line -> source.sendFeedback((class_2561)class_2561.method_43470((String)("  " + line))));
            source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.info.placeholders_header").method_27692(class_124.field_1054));
            if (placeholders.isEmpty()) {
                source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.info.no_placeholders"));
            } else {
                placeholders.forEach(p -> source.sendFeedback((class_2561)class_2561.method_43470((String)("  " + p))));
            }
            return 1;
        })))).then(ClientCommandManager.literal((String)"help").executes(context -> {
            F3UpMain.showHelp((FabricClientCommandSource)context.getSource());
            return 1;
        }))));
    }

    private static void showHelp(FabricClientCommandSource source) {
        source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.help.header").method_27692(class_124.field_1065));
        source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.help.reload"));
        source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.help.list"));
        source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.help.info"));
        source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.help.open"));
        source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.help.version"));
        source.sendFeedback((class_2561)class_2561.method_43471((String)"f3up.command.help.help"));
    }

    private static CompletableFuture<Suggestions> getModuleSuggestions(CommandContext<FabricClientCommandSource> context, SuggestionsBuilder builder) {
        if (CONFIG == null || CONFIG.entries() == null) {
            return Suggestions.empty();
        }
        String remaining = builder.getRemaining().toLowerCase();
        CONFIG.entries().stream().map(e -> e.id().contains(":") ? e.id() : "f3up:" + e.id()).filter(id -> id.toLowerCase().startsWith(remaining)).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
        return builder.buildFuture();
    }

    static {
        CONFIG_MANAGER = new ConfigManager();
        PLACEHOLDER_PROCESSOR = new PlaceholderProcessor();
        PLACEHOLDER_PATTERN = Pattern.compile("\\{([^}]+)}");
        MOD_INIT_TIME = System.currentTimeMillis();
    }
}

