/*
 * Decompiled with CFR 0.152.
 */
package ru.infikot.f3up.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_11631;
import net.minecraft.class_11632;
import net.minecraft.class_155;
import net.minecraft.class_2960;
import ru.infikot.f3up.config.Config;

public class ConfigManager {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final File configFile = new File(FabricLoader.getInstance().getConfigDir().toFile(), "f3up.json");
    private Config config;

    public static File getConfigFile() {
        return configFile;
    }

    public Config getConfig() {
        return this.config;
    }

    public Config loadConfig() throws IOException, JsonSyntaxException {
        try (FileReader reader = new FileReader(configFile);){
            Config loadedConfig = (Config)GSON.fromJson((Reader)reader, Config.class);
            if (loadedConfig == null) {
                throw new JsonSyntaxException("Config file is empty or malformed.");
            }
            if (loadedConfig.entries() != null && !loadedConfig.entries().isEmpty() && loadedConfig.entries().get(0).side() == null) {
                throw new JsonSyntaxException("Old config format detected. A new one will be generated.");
            }
            Config config = loadedConfig;
            return config;
        }
    }

    public void initialLoad() {
        if (!configFile.exists()) {
            System.out.println("F3Up: No config found, creating a new one based on registered game entries...");
            this.createDefaultConfig();
            this.saveConfig();
        }
        try {
            this.config = this.loadConfig();
            if (!this.config.generated_for_version().equals(class_155.method_16673().comp_4025())) {
                System.out.println("F3Up: Config is for a different game version, regenerating...");
                this.createDefaultConfig();
                this.saveConfig();
            }
        }
        catch (Exception e) {
            System.err.println("Failed to read F3Up config, creating a new one. Reason: " + e.getMessage());
            File brokenFile = new File(configFile.getParentFile(), "f3up.json.broken." + System.currentTimeMillis());
            configFile.renameTo(brokenFile);
            System.err.println("Your old config was saved as: " + brokenFile.getName());
            this.createDefaultConfig();
            this.saveConfig();
        }
    }

    private void createDefaultConfig() {
        ArrayList<Config.ConfigEntry> defaultEntries = new ArrayList<Config.ConfigEntry>();
        Map vanillaEntries = class_11631.method_72761();
        vanillaEntries.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> {
            class_2960 id = (class_2960)entry.getKey();
            class_11632 debugEntry = (class_11632)entry.getValue();
            String side = "left";
            int order = 1000;
            if (id.method_12832().contains("system") || id.method_12832().contains("display") || id.method_12832().contains("target") || id.method_12832().contains("looking_at")) {
                side = "right";
            }
            defaultEntries.add(new Config.ConfigEntry(id.toString(), true, side, order, debugEntry.method_72759().comp_4455().getString(), id.method_12832(), "Default entry for " + String.valueOf(id), List.of("{default}")));
        });
        defaultEntries.add(new Config.ConfigEntry("f3up:custom_info", true, "right", 50, "F3Up Custom", "F3Up Example Info", "An example of a custom F3Up module.", Arrays.asList("\u00a7b--- F3Up Example Info ---", "\u00a7eTime: \u00a7f{system.time_24h}", "\u00a7eMod (game) uptime: \u00a7f{game.uptime}", "\u00a7o\u00a78>> Donate: boosty.to/infikot <<")));
        defaultEntries.sort(Comparator.comparing(Config.ConfigEntry::side).thenComparingInt(Config.ConfigEntry::order));
        List<String> placeholders = Arrays.asList("// --- General INFO ---", "// 'global_update_frequency_ms': How often F3 text updates (in milliseconds). 250 = 4 times/sec.", "// 'enabled': true/false. Master switch for this module.", "// 'side': 'left' or 'right'. Where to display the module.", "// 'order': Sorting order, smaller numbers are higher on the screen.", "// 'category': A name for grouping in the F3+F6 menu.", "// Use '{default}' in 'lines' to show the original output for a vanilla module.", "// To use colors, use the section sign (\u00a7) followed by a code. Example: \"\u00a7eHello\" is yellow.", "// Colors: \u00a70-9, \u00a7a-f. Formatting: \u00a7l (bold), \u00a7o (italic), \u00a7n (underline), \u00a7m (strikethrough), \u00a7r (reset).", "//", "// --- Player ---", "player.x, player.y, player.z - Player's coordinates (e.g., {player.x:.2f})", "player.block_x, player.block_y, player.block_z - Player's block coordinates", "player.chunk_x, player.chunk_z - Player's chunk coordinates", "player.chunk_relative_x, player.chunk_relative_z - Coordinates within the chunk (0-15)", "player.facing, player.facing_simple - Direction (e.g., 'north', 'N')", "player.yaw, player.pitch - Player's rotation", "player.speed_mps - Speed in meters/sec", "player.light_level - Light level at player's position", "//", "// --- Items ---", "hand.item.id, hand.item.name - Item in main hand", "hand.item.durability, hand.item.durability_max, hand.item.durability_percent", "offhand.item.id, offhand.item.name - Item in offhand", "offhand.item.durability, offhand.item.durability_max, offhand.item.durability_percent", "//", "// --- Armor ---", "armor.<slot>.name - <slot> can be: head, chest, legs, feet", "armor.<slot>.durability, armor.<slot>.durability_max, armor.<slot>.durability_percent", "//", "// --- Target (what you are looking at) ---", "target.block.id, target.block.name, target.block.x/y/z", "target.entity.id, target.entity.name", "//", "// --- Dynamic: Item Count in Inventory ---", "// Syntax: {inventory.item_count.<item_id>}", "// Right now mods aint supported!!!", "Example: {inventory.item_count.arrow} - Counts all arrows in your main inventory", "Example: {inventory.item_count.diamond} - Counts all diamonds", "//", "// --- Dynamic: Nearby Entities Count ---", "// Syntax: {range.<type>.<radius>} (type: mobs, players, items; radius: 1-120)", "Example: {range.mobs.16} - Counts mobs in a 16-block radius", "//", "// --- Dynamic: Nearest Entity ---", "// Syntax: {nearest.<type>.<property>.<radius>} (property: name, id)", "Example: {nearest.players.name.64} - Name of the nearest player in 64 blocks", "//", "// --- World & Server ---", "world.time, world.time_24h, world.days - World time information", "world.biome, world.weather, world.moon_phase, world.local_difficulty", "server.tps - Server TPS (Singleplayer only)", "server.name, server.motd, server.version, server.ip, server.port", "server.ping - Your ping to the server", "server.players, server.max_players, server.render_distance", "//", "// --- Game & System ---", "game.version, game.name - Minecraft version info", "game.fps, game.frametime_ms - FPS and frame time (e.g., {game.fps} fps ({game.frametime_ms:.2f} ms))", "memory.used_mb, memory.total_mb, memory.max_mb, memory.used_percent - Memory usage", "game.status - 'active' or 'unfocused'", "game.uptime - Time since mod was initialized", "system.time_24h, system.time_12h - Your real system time", "// Use standard Java DateTimeFormatter patterns for date. (e.g., yyyy-MM-dd HH:mm:ss)", "system.date.<format> - Example: {system.date.dd-MM-yyyy}");
        this.config = new Config(class_155.method_16673().comp_4025(), 250, placeholders, defaultEntries);
    }

    public void saveConfig() {
        try (FileWriter writer = new FileWriter(configFile);){
            GSON.toJson((Object)this.config, (Appendable)writer);
        }
        catch (IOException e) {
            System.err.println("Could not save F3Up config file!");
            e.printStackTrace();
        }
    }
}

