/*
 * Decompiled with CFR 0.152.
 */
package ru.infikot.f3up.hud;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.class_1132;
import net.minecraft.class_1267;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1542;
import net.minecraft.class_155;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_640;
import net.minecraft.class_642;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7923;
import net.minecraft.class_9279;
import net.minecraft.class_9334;
import ru.infikot.f3up.F3UpMain;

public class PlaceholderProcessor {
    private static final Pattern PLACEHOLDER_PATTERN = Pattern.compile("\\{([^}]+)}");
    private final Map<String, Supplier<Object>> suppliers = new HashMap<String, Supplier<Object>>();
    private final Map<String, DateTimeFormatter> dateFormatters = new HashMap<String, DateTimeFormatter>();

    public PlaceholderProcessor() {
        this.registerPlaceholders();
    }

    private void registerPlaceholders() {
        class_310 client = class_310.method_1551();
        this.suppliers.put("player.x", () -> client.field_1724 != null ? client.field_1724.method_23317() : 0.0);
        this.suppliers.put("player.y", () -> client.field_1724 != null ? client.field_1724.method_23318() : 0.0);
        this.suppliers.put("player.z", () -> client.field_1724 != null ? client.field_1724.method_23321() : 0.0);
        this.suppliers.put("player.block_x", () -> client.field_1724 != null ? client.field_1724.method_24515().method_10263() : 0);
        this.suppliers.put("player.block_y", () -> client.field_1724 != null ? client.field_1724.method_24515().method_10264() : 0);
        this.suppliers.put("player.block_z", () -> client.field_1724 != null ? client.field_1724.method_24515().method_10260() : 0);
        this.suppliers.put("player.chunk_x", () -> client.field_1724 != null ? client.field_1724.method_31476().field_9181 : 0);
        this.suppliers.put("player.chunk_z", () -> client.field_1724 != null ? client.field_1724.method_31476().field_9180 : 0);
        this.suppliers.put("player.chunk_relative_x", () -> client.field_1724 != null ? client.field_1724.method_24515().method_10263() & 0xF : 0);
        this.suppliers.put("player.chunk_relative_y", () -> client.field_1724 != null ? client.field_1724.method_24515().method_10264() : 0);
        this.suppliers.put("player.chunk_relative_z", () -> client.field_1724 != null ? client.field_1724.method_24515().method_10260() & 0xF : 0);
        this.suppliers.put("player.facing", () -> client.field_1724 != null ? client.field_1724.method_5735().method_15434() : "N/A");
        this.suppliers.put("player.facing_simple", () -> client.field_1724 != null ? client.field_1724.method_5735().toString().substring(0, 1).toUpperCase() : "N/A");
        this.suppliers.put("player.yaw", () -> client.field_1724 != null ? (double)class_3532.method_15393((float)client.field_1724.method_36454()) : 0.0);
        this.suppliers.put("player.pitch", () -> client.field_1724 != null ? (double)class_3532.method_15393((float)client.field_1724.method_36455()) : 0.0);
        this.suppliers.put("player.speed_mps", () -> client.field_1724 != null ? client.field_1724.method_18798().method_37267() * 20.0 : 0.0);
        this.suppliers.put("player.light_level", () -> client.field_1687 != null && client.field_1724 != null ? client.field_1687.method_22339(client.field_1724.method_24515()) : 0);
        this.suppliers.put("hand.item.id", () -> client.field_1724 != null ? class_7923.field_41178.method_10221((Object)client.field_1724.method_6047().method_7909()) : "minecraft:air");
        this.suppliers.put("hand.item.name", () -> client.field_1724 != null ? client.field_1724.method_6047().method_7964().getString() : "Air");
        this.suppliers.put("hand.item.rarity", () -> client.field_1724 != null ? client.field_1724.method_6047().method_7932().name() : "COMMON");
        this.suppliers.put("hand.item.durability", () -> {
            if (client.field_1724 == null) {
                return 0;
            }
            class_1799 stack = client.field_1724.method_6047();
            return stack.method_7963() ? stack.method_7936() - stack.method_7919() : 0;
        });
        this.suppliers.put("hand.item.durability_max", () -> {
            if (client.field_1724 == null) {
                return 0;
            }
            return client.field_1724.method_6047().method_7936();
        });
        this.suppliers.put("hand.item.durability_percent", () -> {
            if (client.field_1724 == null) {
                return 100.0;
            }
            class_1799 stack = client.field_1724.method_6047();
            if (stack.method_7960() || !stack.method_7963()) {
                return 100.0;
            }
            return 100.0 * (double)(stack.method_7936() - stack.method_7919()) / (double)stack.method_7936();
        });
        this.suppliers.put("hand.item.nbt", () -> {
            if (client.field_1724 == null) {
                return "{}";
            }
            class_1799 stack = client.field_1724.method_6047();
            if (stack.method_7960() || !stack.method_57826(class_9334.field_49628)) {
                return "{}";
            }
            class_9279 nbtComponent = (class_9279)stack.method_58694(class_9334.field_49628);
            return nbtComponent != null ? nbtComponent.method_57461().toString() : "{}";
        });
        this.suppliers.put("offhand.item.id", () -> client.field_1724 != null ? class_7923.field_41178.method_10221((Object)client.field_1724.method_6079().method_7909()) : "minecraft:air");
        this.suppliers.put("offhand.item.name", () -> client.field_1724 != null ? client.field_1724.method_6079().method_7964().getString() : "Air");
        this.suppliers.put("offhand.item.rarity", () -> client.field_1724 != null ? client.field_1724.method_6079().method_7932().name() : "COMMON");
        this.suppliers.put("offhand.item.durability", () -> {
            if (client.field_1724 == null) {
                return 0;
            }
            class_1799 stack = client.field_1724.method_6079();
            return stack.method_7963() ? stack.method_7936() - stack.method_7919() : 0;
        });
        this.suppliers.put("offhand.item.durability_max", () -> {
            if (client.field_1724 == null) {
                return 0;
            }
            return client.field_1724.method_6079().method_7936();
        });
        this.suppliers.put("offhand.item.durability_percent", () -> {
            if (client.field_1724 == null) {
                return 100.0;
            }
            class_1799 stack = client.field_1724.method_6079();
            if (stack.method_7960() || !stack.method_7963()) {
                return 100.0;
            }
            return 100.0 * (double)(stack.method_7936() - stack.method_7919()) / (double)stack.method_7936();
        });
        this.suppliers.put("offhand.item.nbt", () -> {
            if (client.field_1724 == null) {
                return "{}";
            }
            class_1799 stack = client.field_1724.method_6079();
            if (stack.method_7960() || !stack.method_57826(class_9334.field_49628)) {
                return "{}";
            }
            class_9279 nbtComponent = (class_9279)stack.method_58694(class_9334.field_49628);
            return nbtComponent != null ? nbtComponent.method_57461().toString() : "{}";
        });
        this.registerArmorPlaceholders("head", class_1304.field_6169);
        this.registerArmorPlaceholders("chest", class_1304.field_6174);
        this.registerArmorPlaceholders("legs", class_1304.field_6172);
        this.registerArmorPlaceholders("feet", class_1304.field_6166);
        this.suppliers.put("target.block.id", () -> this.getTargetedBlock() != null ? class_7923.field_41175.method_10221((Object)this.getTargetedBlock()) : "N/A");
        this.suppliers.put("target.block.name", () -> this.getTargetedBlock() != null ? this.getTargetedBlock().method_9518().getString() : "N/A");
        this.suppliers.put("target.block.x", () -> this.getTargetedBlockPos() != null ? Integer.valueOf(this.getTargetedBlockPos().method_10263()) : "N/A");
        this.suppliers.put("target.block.y", () -> this.getTargetedBlockPos() != null ? Integer.valueOf(this.getTargetedBlockPos().method_10264()) : "N/A");
        this.suppliers.put("target.block.z", () -> this.getTargetedBlockPos() != null ? Integer.valueOf(this.getTargetedBlockPos().method_10260()) : "N/A");
        this.suppliers.put("target.entity.id", () -> this.getTargetedEntity() != null ? class_7923.field_41177.method_10221((Object)this.getTargetedEntity().method_5864()) : "N/A");
        this.suppliers.put("target.entity.name", () -> this.getTargetedEntity() != null ? this.getTargetedEntity().method_5477().getString() : "N/A");
        this.suppliers.put("world.time", () -> client.field_1687 != null ? client.field_1687.method_8510() : 0L);
        this.suppliers.put("world.time_24h", () -> {
            if (client.field_1687 == null) {
                return "00:00";
            }
            long time = client.field_1687.method_8532();
            int hours = (int)((time / 1000L + 6L) % 24L);
            int minutes = (int)(time % 1000L * 60L / 1000L);
            return String.format("%02d:%02d", hours, minutes);
        });
        this.suppliers.put("world.days", () -> client.field_1687 != null ? client.field_1687.method_8510() / 24000L : 0L);
        this.suppliers.put("world.biome", () -> {
            if (client.field_1724 == null || client.field_1687 == null) {
                return "unknown";
            }
            class_6880 biome = client.field_1687.method_23753(client.field_1724.method_24515());
            return biome.method_40229().map(key -> key.method_29177().toString(), value -> "[unregistered]");
        });
        this.suppliers.put("world.weather", () -> {
            if (client.field_1687 == null) {
                return "N/A";
            }
            if (client.field_1687.method_8546()) {
                return "thunder";
            }
            if (client.field_1687.method_8419()) {
                return "rain";
            }
            return "clear";
        });
        this.suppliers.put("world.moon_phase", () -> client.field_1687 != null ? client.field_1687.method_30273() : 0);
        this.suppliers.put("world.local_difficulty", () -> client.field_1687 != null ? client.field_1687.method_8407().method_5461() : class_1267.field_5805.method_5461());
        this.suppliers.put("server.tps", () -> {
            class_1132 server = client.method_1576();
            if (server != null) {
                float mspt = server.method_54832();
                float tps = Math.min(20.0f, 1000.0f / mspt);
                return String.format("%.2f tps", Float.valueOf(tps));
            }
            return "N/A (Multiplayer)";
        });
        this.suppliers.put("server.name", () -> {
            class_642 serverData = client.method_1558();
            return serverData != null ? serverData.field_3752 : (client.method_1496() ? "Singleplayer" : "N/A");
        });
        this.suppliers.put("server.motd", () -> {
            class_642 serverData = client.method_1558();
            class_2561 label = serverData != null ? serverData.field_3757 : null;
            return label != null ? label.getString().replaceAll("\n", " ") : "N/A";
        });
        this.suppliers.put("server.version", () -> {
            class_642 serverData = client.method_1558();
            return serverData != null ? serverData.field_3760.getString() : "N/A";
        });
        this.suppliers.put("server.ip", () -> client.method_1558() != null ? client.method_1558().field_3761 : "127.0.0.1");
        this.suppliers.put("server.port", () -> "25565");
        this.suppliers.put("server.ping", () -> {
            if (client.method_1562() == null || client.field_1724 == null) {
                return 0;
            }
            class_640 entry = client.method_1562().method_2871(client.field_1724.method_5667());
            return entry != null ? entry.method_2959() : 0;
        });
        this.suppliers.put("server.players", () -> client.method_1562() != null ? client.method_1562().method_2880().size() : 1);
        this.suppliers.put("server.max_players", () -> {
            class_642 serverData = client.method_1558();
            if (serverData != null && serverData.field_3753 != null) {
                return serverData.field_3753.getString();
            }
            return client.method_1576() != null ? Integer.valueOf(client.method_1576().method_3802()) : "N/A";
        });
        this.suppliers.put("server.render_distance", () -> client.field_1690.method_42503().method_41753());
        this.suppliers.put("game.version", () -> class_155.method_16673().comp_4025());
        this.suppliers.put("game.name", () -> client.method_1515());
        this.suppliers.put("game.fps", () -> ((class_310)client).method_47599());
        this.suppliers.put("game.frametime_ms", () -> 1000.0 / (double)client.method_47599());
        this.suppliers.put("memory.used_mb", () -> (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L);
        this.suppliers.put("memory.total_mb", () -> Runtime.getRuntime().totalMemory() / 1024L / 1024L);
        this.suppliers.put("memory.max_mb", () -> Runtime.getRuntime().maxMemory() / 1024L / 1024L);
        this.suppliers.put("memory.used_percent", () -> {
            long total = Runtime.getRuntime().totalMemory();
            long used = total - Runtime.getRuntime().freeMemory();
            return total > 0L ? used * 100L / total : 0L;
        });
        this.suppliers.put("game.status", () -> client.method_1569() ? "active" : "unfocused");
        this.suppliers.put("game.uptime", () -> {
            long uptimeSeconds = (System.currentTimeMillis() - F3UpMain.MOD_INIT_TIME) / 1000L;
            long hours = uptimeSeconds / 3600L;
            long minutes = uptimeSeconds % 3600L / 60L;
            long seconds = uptimeSeconds % 60L;
            return String.format("%02d:%02d:%02d", hours, minutes, seconds);
        });
        this.suppliers.put("system.time_24h", () -> LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm")));
        this.suppliers.put("system.time_12h", () -> LocalDateTime.now().format(DateTimeFormatter.ofPattern("hh:mm a")));
    }

    private void registerArmorPlaceholders(String name, class_1304 slot) {
        class_310 client = class_310.method_1551();
        Supplier<class_1799> getArmor = () -> {
            if (client.field_1724 == null) {
                return class_1799.field_8037;
            }
            return client.field_1724.method_6118(slot);
        };
        this.suppliers.put("armor." + name + ".name", () -> ((class_1799)getArmor.get()).method_7964().getString());
        this.suppliers.put("armor." + name + ".durability", () -> ((class_1799)getArmor.get()).method_7986() ? ((class_1799)getArmor.get()).method_7936() - ((class_1799)getArmor.get()).method_7919() : ((class_1799)getArmor.get()).method_7936());
        this.suppliers.put("armor." + name + ".durability_max", () -> ((class_1799)getArmor.get()).method_7936());
        this.suppliers.put("armor." + name + ".durability_percent", () -> {
            class_1799 stack = (class_1799)getArmor.get();
            if (stack.method_7960() || !stack.method_7963()) {
                return 100.0;
            }
            return 100.0 * (double)(stack.method_7936() - stack.method_7919()) / (double)stack.method_7936();
        });
    }

    private class_239 getCrosshairTarget() {
        return class_310.method_1551().field_1765;
    }

    private class_2248 getTargetedBlock() {
        class_239 target = this.getCrosshairTarget();
        if (target instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)target;
            return Objects.requireNonNull(class_310.method_1551().field_1687).method_8320(blockHitResult.method_17777()).method_26204();
        }
        return null;
    }

    private class_2338 getTargetedBlockPos() {
        class_239 target = this.getCrosshairTarget();
        if (target instanceof class_3965) {
            class_3965 blockHitResult = (class_3965)target;
            return blockHitResult.method_17777();
        }
        return null;
    }

    private class_1297 getTargetedEntity() {
        class_239 target = this.getCrosshairTarget();
        if (target instanceof class_3966) {
            class_3966 entityHitResult = (class_3966)target;
            return entityHitResult.method_17782();
        }
        return null;
    }

    private String handleDynamicPlaceholder(String key) {
        class_310 client = class_310.method_1551();
        if (client.field_1724 == null) {
            return "0";
        }
        try {
            String[] parts = key.split("\\.");
            if (parts.length < 2) {
                return "<Invalid Syntax>";
            }
            String type = parts[0];
            if ("range".equals(type)) {
                long count;
                if (parts.length != 3) {
                    return "<Invalid Syntax>";
                }
                String entityType = parts[1];
                int radius = Integer.parseInt(parts[2]);
                if (radius == 0) {
                    radius = 120;
                }
                radius = Math.max(1, Math.min(120, radius));
                class_238 area = new class_238(client.field_1724.method_24515()).method_1014((double)radius);
                switch (entityType.toLowerCase()) {
                    case "players": {
                        count = client.field_1687.method_18456().stream().filter(p -> !p.equals((Object)client.field_1724) && p.method_5829().method_994(area)).count();
                        break;
                    }
                    case "mobs": {
                        count = client.field_1687.method_8390(class_1308.class, area, e -> true).size();
                        break;
                    }
                    case "items": {
                        count = client.field_1687.method_8390(class_1542.class, area, e -> true).size();
                        break;
                    }
                    default: {
                        return "<Invalid Type>";
                    }
                }
                return String.valueOf(count);
            }
            if ("nearest".equals(type)) {
                Optional<class_1308> nearestEntity;
                if (parts.length != 4) {
                    return "<Invalid Syntax>";
                }
                String entityType = parts[1];
                String property = parts[2];
                int radius = Integer.parseInt(parts[3]);
                if (radius == 0) {
                    radius = 120;
                }
                radius = Math.max(1, Math.min(120, radius));
                class_238 area = new class_238(client.field_1724.method_24515()).method_1014((double)radius);
                class_746 player = client.field_1724;
                switch (entityType.toLowerCase()) {
                    case "players": {
                        nearestEntity = client.field_1687.method_18456().stream().filter(p -> !p.equals((Object)player) && p.method_5829().method_994(area)).min(Comparator.comparingDouble(p -> p.method_5858((class_1297)player)));
                        break;
                    }
                    case "mobs": {
                        nearestEntity = client.field_1687.method_8390(class_1308.class, area, e -> true).stream().min(Comparator.comparingDouble(m -> m.method_5858((class_1297)player)));
                        break;
                    }
                    case "items": {
                        nearestEntity = client.field_1687.method_8390(class_1542.class, area, e -> true).stream().min(Comparator.comparingDouble(i -> i.method_5858((class_1297)player)));
                        break;
                    }
                    default: {
                        return "<Invalid Type>";
                    }
                }
                if (nearestEntity.isPresent()) {
                    class_1297 entity = (class_1297)nearestEntity.get();
                    switch (property.toLowerCase()) {
                        case "name": {
                            return entity.method_5477().getString();
                        }
                        case "id": {
                            return class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
                        }
                    }
                    return "<Invalid Property>";
                }
                return "N/A";
            }
            if ("inventory".equals(type) && "item_count".equals(parts[1])) {
                class_1792 item;
                if (parts.length != 3) {
                    return "<Invalid Syntax>";
                }
                String itemId = parts[2];
                class_2960 id = class_2960.method_12829((String)itemId);
                if (id == null || !itemId.contains(":")) {
                    id = class_2960.method_60655((String)"minecraft", (String)itemId);
                }
                if ((item = (class_1792)class_7923.field_41178.method_63535(id)) == class_7923.field_41178.method_63535(class_2960.method_60655((String)"minecraft", (String)"air"))) {
                    return "<Unknown Item>";
                }
                int count = 0;
                for (int i2 = 0; i2 < client.field_1724.method_31548().method_5439(); ++i2) {
                    class_1799 stack = client.field_1724.method_31548().method_5438(i2);
                    if (stack.method_7909() != item) continue;
                    count += stack.method_7947();
                }
                return String.valueOf(count);
            }
            if ("system".equals(type) && "date".equals(parts[1])) {
                if (parts.length != 3) {
                    return "<Invalid Date Format>";
                }
                String format = parts[2];
                DateTimeFormatter formatter = this.dateFormatters.computeIfAbsent(format, DateTimeFormatter::ofPattern);
                return LocalDateTime.now().format(formatter);
            }
            return "<Error>";
        }
        catch (Exception e2) {
            return "<Error>";
        }
    }

    public String process(String line) {
        if (line == null) {
            return "";
        }
        Matcher matcher = PLACEHOLDER_PATTERN.matcher(line);
        StringBuilder result = new StringBuilder();
        while (matcher.find()) {
            String value;
            block9: {
                String format;
                String fullPlaceholder = matcher.group(1);
                String[] parts = fullPlaceholder.split(":", 2);
                String key = parts[0];
                String string = format = parts.length > 1 ? "%" + parts[1] : "%s";
                if (key.startsWith("range.") || key.startsWith("nearest.") || key.startsWith("system.date.") || key.startsWith("inventory.item_count.")) {
                    value = this.handleDynamicPlaceholder(key);
                } else {
                    Supplier<Object> supplier = this.suppliers.get(key);
                    if (supplier != null) {
                        try {
                            Object suppliedValue = supplier.get();
                            if (suppliedValue instanceof Number && (format.contains("f") || format.contains("d") || format.contains("."))) {
                                value = String.format(Locale.US, format, suppliedValue);
                                break block9;
                            }
                            value = String.format(format, suppliedValue);
                        }
                        catch (Exception e) {
                            value = "\u00a7c<ERR>\u00a7r";
                        }
                    } else {
                        value = "\u00a7c<UNKNOWN>\u00a7r";
                    }
                }
            }
            matcher.appendReplacement(result, Matcher.quoteReplacement(value));
        }
        matcher.appendTail(result);
        return result.toString();
    }
}

