/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack;

import dev.kinau.myresourcepack.PackSettings;
import dev.kinau.myresourcepack.command.MyResourcePackCommand;
import dev.kinau.myresourcepack.config.ServerSetting;
import dev.kinau.myresourcepack.config.resource.ResourceDirectory;
import dev.kinau.myresourcepack.config.resource.ResourceObject;
import dev.kinau.myresourcepack.expander.ClientCommonPacketListenerImplExpander;
import dev.kinau.myresourcepack.expander.PackConfirmScreenExpander;
import dev.kinau.myresourcepack.expander.PackResourceExpander;
import dev.kinau.myresourcepack.screen.ResourceSelectionScreen;
import dev.kinau.myresourcepack.screen.components.buttons.ConfigButton;
import dev.kinau.myresourcepack.screen.components.buttons.Switch;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientConfigurationConnectionEvents;
import net.fabricmc.fabric.api.client.screen.v1.ScreenEvents;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_11907;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2596;
import net.minecraft.class_2856;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3258;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_327;
import net.minecraft.class_3288;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_4286;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5352;
import net.minecraft.class_5375;
import net.minecraft.class_634;
import net.minecraft.class_642;
import net.minecraft.class_7417;
import net.minecraft.class_8614;
import net.minecraft.class_8673;
import net.minecraft.class_8674;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MyResourcePack
implements ModInitializer {
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"myresourcepack");
    private static MyResourcePack instance;
    private PackSettings packSettings;
    private boolean reloadResources = false;
    private boolean configuringPackOrder = false;
    private boolean shouldOpenConfigGui = false;
    private class_642 pendingServerData;
    private class_8674 pendingConnection;

    public void onInitialize() {
        instance = this;
        this.packSettings = new PackSettings();
        ClientConfigurationConnectionEvents.INIT.register(this::setPendingConnection);
        ClientConfigurationConnectionEvents.COMPLETE.register(this::resetPendingConnection);
        ClientConfigurationConnectionEvents.DISCONNECT.register(this::resetPendingConnection);
        this.registerGui();
        this.registerCommand();
    }

    private void setPendingConnection(class_8674 handler, class_310 client) {
        this.pendingConnection = handler;
        this.pendingServerData = ((ClientCommonPacketListenerImplExpander)handler).getServerData();
    }

    private void resetPendingConnection(class_8674 handler, class_310 client) {
        this.pendingConnection = null;
        this.pendingServerData = null;
    }

    public String getCurrentServer() {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.method_47392()) {
            return null;
        }
        class_642 serverData = minecraft.method_1558();
        if (serverData == null) {
            if (this.pendingServerData == null) {
                return null;
            }
            return this.pendingServerData.field_3761;
        }
        return serverData.field_3761;
    }

    private void registerGui() {
        try {
            ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
                if (!(screen instanceof class_5375)) {
                    return;
                }
                final class_310 minecraft = Screens.getClient((class_437)screen);
                boolean hasServerPack = minecraft.method_1520().method_14444().stream().anyMatch(pack -> pack.method_29483() == class_5352.field_25350);
                if (!hasServerPack) {
                    return;
                }
                String currentServer = this.getCurrentServer();
                if (currentServer == null) {
                    return;
                }
                ServerSetting setting = this.packSettings.getConfigData().getSettings(currentServer);
                List buttons = Screens.getButtons((class_437)screen);
                ConfigButton configButton = new ConfigButton(scaledWidth - 20 - 5, scaledHeight - 20 - 6, 20, 20, !setting.overrideTextures()){

                    public void method_25306(class_11907 inputWithModifiers) {
                        MyResourcePack.this.pressConfigButton(minecraft);
                    }
                };
                Switch switchButton = (Switch)this.createToggle(minecraft, scaledWidth, setting, scaledHeight - 20 - 6, overrideTextures -> {
                    configButton.field_22763 = overrideTextures == false;
                }, true);
                try {
                    buttons.removeIf(abstractWidget -> abstractWidget instanceof ConfigButton);
                    buttons.add(configButton);
                    buttons.removeIf(abstractWidget -> abstractWidget instanceof Switch);
                    buttons.add(switchButton);
                    buttons.forEach(abstractWidget -> {
                        if (abstractWidget instanceof class_4185) {
                            class_2588 translatableContents;
                            class_4185 button = (class_4185)abstractWidget;
                            class_7417 patt0$temp = button.method_25369().method_10851();
                            if (patt0$temp instanceof class_2588 && (translatableContents = (class_2588)patt0$temp).method_11022().equals("gui.done")) {
                                button.method_46421(scaledWidth / 2 - 50);
                                button.method_25358(Math.max(65, switchButton.method_46426() - button.method_46426() - 5));
                            } else {
                                class_2588 translatableContents2;
                                class_7417 patt1$temp = button.method_25369().method_10851();
                                if (patt1$temp instanceof class_2588 && (translatableContents2 = (class_2588)patt1$temp).method_11022().equals("pack.openFolder")) {
                                    button.method_46421(scaledWidth / 2 - button.method_25368() - 50 - 5);
                                }
                            }
                        }
                    });
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    // empty catch block
                }
            });
            ScreenEvents.AFTER_INIT.register((client, screen, scaledWidth, scaledHeight) -> {
                class_2588 translatableContents;
                if (!(screen instanceof class_8673.class_9058)) {
                    return;
                }
                class_8673.class_9058 confirmScreen = (class_8673.class_9058)screen;
                class_7417 class_74172 = confirmScreen.method_25440().method_10851();
                boolean required = class_74172 instanceof class_2588 && (translatableContents = (class_2588)class_74172).method_11022().startsWith("multiplayer.requiredTexturePrompt.line");
                String currentServer = this.getCurrentServer();
                if (currentServer == null) {
                    return;
                }
                ServerSetting setting = this.packSettings.getConfigData().getSettings(currentServer);
                List buttons = Screens.getButtons((class_437)screen);
                buttons.forEach(abstractWidget -> abstractWidget.method_48229(abstractWidget.method_46426(), abstractWidget.method_46427() + 15));
                int y = ((class_364)screen.method_25396().get(0)).method_48202().comp_1195().comp_1194() - 30;
                class_4264 checkbox = this.createToggle(client, scaledWidth, setting, y, a -> {}, false);
                buttons.add(checkbox);
                if (required) {
                    buttons.stream().filter(widget -> {
                        class_2588 contents;
                        class_4185 button;
                        class_7417 patt0$temp;
                        return widget instanceof class_4185 && (patt0$temp = (button = (class_4185)widget).method_25369().method_10851()) instanceof class_2588 && (contents = (class_2588)patt0$temp).method_11022().equals("gui.proceed");
                    }).findAny().ifPresent(proceedButton -> {
                        int newButtonY = proceedButton.method_46427() + proceedButton.method_25364() + 8;
                        buttons.add(class_4185.method_46430((class_2561)class_2561.method_43471((String)"ignore_resource_pack"), button -> {
                            class_634 packetListener = client.method_1562();
                            if (packetListener == null && (packetListener = this.pendingConnection) == null) {
                                return;
                            }
                            if (!(confirmScreen instanceof PackConfirmScreenExpander)) {
                                return;
                            }
                            PackConfirmScreenExpander packScreen = (PackConfirmScreenExpander)confirmScreen;
                            for (class_8673.class_9058.class_9059 pendingRequest : packScreen.getRequests()) {
                                packetListener.method_52787((class_2596)new class_2856(pendingRequest.comp_2172(), class_2856.class_2857.field_13016));
                                packetListener.method_52787((class_2596)new class_2856(pendingRequest.comp_2172(), class_2856.class_2857.field_47704));
                                packetListener.method_52787((class_2596)new class_2856(pendingRequest.comp_2172(), class_2856.class_2857.field_13017));
                            }
                            client.method_1507(((PackConfirmScreenExpander)confirmScreen).getParentScreen());
                        }).method_46434(scaledWidth / 2 - 155, newButtonY, 150, 20).method_46431());
                    });
                }
            });
        }
        catch (NoClassDefFoundError ex) {
            LOGGER.error("Couldn't register screen handler as Fabric Screen isn't installed", (Throwable)ex);
        }
    }

    @NotNull
    private class_4264 createToggle(class_310 minecraft, int scaledWidth, ServerSetting setting, int y, final Consumer<Boolean> callBack, boolean reloadResources) {
        int width;
        int height = 20;
        final Consumer<Boolean> onPress = pressed -> {
            setting.overrideTextures((boolean)pressed);
            try {
                this.packSettings.saveConfig();
            }
            catch (IOException ex) {
                LOGGER.error("Couldn't save config", (Throwable)ex);
            }
            if (reloadResources) {
                this.reloadResources = !this.reloadResources;
            }
        };
        class_5250 component = reloadResources ? class_2561.method_43471((String)"enable_resource_blocking") : class_2561.method_43471((String)"override_textures_button");
        int n = width = reloadResources ? 64 + minecraft.field_1772.method_27525((class_5348)component) : 24 + minecraft.field_1772.method_27525((class_5348)component);
        return reloadResources ? new Switch(this, scaledWidth - width - 24 - 5, y, width, height, (class_2561)component, !setting.overrideTextures()){

            @Override
            public void method_25306(class_11907 inputWithModifiers) {
                super.method_25306(inputWithModifiers);
                callBack.accept(!this.enabled());
                onPress.accept(!this.enabled());
            }
        } : class_4286.method_54787((class_2561)component, (class_327)minecraft.field_1772).method_54789(scaledWidth / 2 - width / 2, y).method_54794(setting.overrideTextures()).method_54791((checkbox, selected) -> {
            callBack.accept(selected);
            onPress.accept(selected);
        }).method_54788();
    }

    private void pressConfigButton(class_310 minecraft) {
        List<class_3288> serverPacks = minecraft.method_1520().method_14444().stream().filter(pack -> pack.method_29483() == class_5352.field_25350).toList();
        if (serverPacks.isEmpty()) {
            return;
        }
        ArrayList<ResourceDirectory> packDirectories = new ArrayList<ResourceDirectory>();
        for (class_3288 pack2 : serverPacks) {
            ResourceDirectory root = new ResourceDirectory(class_2960.method_60655((String)"", (String)""));
            try (class_3262 packResources = pack2.method_14458();){
                packResources.method_14406(class_3264.field_14188).forEach(namespace -> {
                    if (packResources instanceof class_8614 || packResources instanceof class_3258) {
                        ResourceDirectory directory = ((PackResourceExpander)packResources).myResourcePack$createResourceTree(class_3264.field_14188, (String)namespace);
                        root.addChild(directory);
                    }
                });
            }
            packDirectories.add(root);
        }
        ResourceDirectory merged = (ResourceDirectory)packDirectories.get(0);
        for (int i = 1; i < packDirectories.size(); ++i) {
            merged = merged.merge((ResourceObject)packDirectories.get(i));
        }
        minecraft.method_1507((class_437)new ResourceSelectionScreen(minecraft.field_1755, merged));
    }

    private void registerCommand() {
        ClientTickEvents.END_CLIENT_TICK.register(client -> {
            if (this.shouldOpenConfigGui) {
                this.shouldOpenConfigGui = false;
                this.pressConfigButton(client);
            }
        });
        ClientCommandRegistrationCallback.EVENT.register((Object)new MyResourcePackCommand(this));
    }

    public PackSettings getPackSettings() {
        return this.packSettings;
    }

    public boolean isReloadResources() {
        return this.reloadResources;
    }

    public boolean isConfiguringPackOrder() {
        return this.configuringPackOrder;
    }

    public boolean isShouldOpenConfigGui() {
        return this.shouldOpenConfigGui;
    }

    public class_642 getPendingServerData() {
        return this.pendingServerData;
    }

    public class_8674 getPendingConnection() {
        return this.pendingConnection;
    }

    public static MyResourcePack getInstance() {
        return instance;
    }

    public void setReloadResources(boolean reloadResources) {
        this.reloadResources = reloadResources;
    }

    public void setConfiguringPackOrder(boolean configuringPackOrder) {
        this.configuringPackOrder = configuringPackOrder;
    }

    public void setShouldOpenConfigGui(boolean shouldOpenConfigGui) {
        this.shouldOpenConfigGui = shouldOpenConfigGui;
    }
}

