/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack.config.resource;

import dev.kinau.myresourcepack.MyResourcePack;
import dev.kinau.myresourcepack.config.ResourceAction;
import dev.kinau.myresourcepack.config.ResourceRule;
import dev.kinau.myresourcepack.config.resource.ResourceFile;
import dev.kinau.myresourcepack.config.resource.ResourceObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_151;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ResourceDirectory
extends ResourceObject
implements Cloneable {
    private final List<ResourceObject> children = new ArrayList<ResourceObject>();
    private ResourceAction ruleAction;

    public ResourceDirectory(class_2960 identifier) {
        super(identifier);
    }

    public ResourceDirectory getOrCreateDir(String part) {
        Optional<ResourceDirectory> optDir = this.children.stream().filter((? super T resourceObject) -> resourceObject instanceof ResourceDirectory).map(resourceObject -> (ResourceDirectory)resourceObject).filter((? super T resourceDirectory) -> resourceDirectory.location().method_12832().endsWith("/" + part) || resourceDirectory.location().method_12832().equals(part)).findAny();
        if (optDir.isPresent()) {
            return optDir.get();
        }
        Object addedPath = this.location().method_12832() + "/" + part;
        if (((String)addedPath).startsWith("/")) {
            addedPath = ((String)addedPath).substring(1);
        }
        try {
            class_2960 identifier = class_2960.method_60655((String)this.location().method_12836(), (String)addedPath);
            ResourceDirectory addedDir = new ResourceDirectory(identifier);
            this.children.add(addedDir);
            return addedDir;
        }
        catch (class_151 ex) {
            MyResourcePack.LOGGER.error("Could not create resource directory for {}", (Object)(this.location().method_12836() + ":" + (String)addedPath));
            return null;
        }
    }

    public ResourceDirectory merge(ResourceObject object) {
        if (object instanceof ResourceFile) {
            if (this.children().stream().anyMatch(object1 -> object1.location().toString().equals(object.location().toString()))) {
                return this;
            }
            this.addChild(object);
            return this;
        }
        if (object instanceof ResourceDirectory) {
            ResourceDirectory dirToAdd = (ResourceDirectory)object;
            Optional<ResourceObject> optChild = this.children().stream().filter((? super T object1) -> object1.location().toString().equals(dirToAdd.location().toString())).findAny();
            if (optChild.isPresent()) {
                ResourceObject existing = optChild.get();
                if (existing instanceof ResourceFile) {
                    this.addChild(object);
                } else if (existing instanceof ResourceDirectory) {
                    ResourceDirectory existingDir = (ResourceDirectory)existing;
                    dirToAdd.children().forEach(existingDir::merge);
                }
            } else {
                this.addChild(object);
                return this;
            }
        }
        return this;
    }

    public Optional<ResourceFile> findFile(class_2960 identifier) {
        for (ResourceObject child : this.children()) {
            ResourceDirectory dir;
            Optional<ResourceFile> optFile;
            ResourceFile file;
            if (child instanceof ResourceFile && (file = (ResourceFile)child).location().toString().equals(identifier.toString())) {
                return Optional.of(file);
            }
            if (!(child instanceof ResourceDirectory) || !(optFile = (dir = (ResourceDirectory)child).findFile(identifier)).isPresent()) continue;
            return optFile;
        }
        return Optional.empty();
    }

    public Optional<ResourceDirectory> findDirectory(class_2960 identifier) {
        if (this.location().toString().equals(identifier.toString())) {
            return Optional.of(this);
        }
        for (ResourceObject child : this.children()) {
            if (!(child instanceof ResourceDirectory)) continue;
            ResourceDirectory dir = (ResourceDirectory)child;
            if (dir.location().toString().equals(identifier.toString())) {
                return Optional.of(dir);
            }
            Optional<ResourceDirectory> optDir = dir.findDirectory(identifier);
            if (!optDir.isPresent()) continue;
            return optDir;
        }
        return Optional.empty();
    }

    public void applyRule(ResourceRule rule) {
        this.applyRule(rule, false);
    }

    public void applyRule(ResourceRule rule, boolean appliedAtParent) {
        if (!appliedAtParent && rule.matches(this.location().toString())) {
            this.ruleAction(rule.action());
            appliedAtParent = true;
        }
        boolean finalAppliedAtParent = appliedAtParent;
        this.children().forEach(object -> {
            if (rule.matches(object.location().toString())) {
                object.action(rule.action());
            }
            if (object instanceof ResourceDirectory) {
                ResourceDirectory dir = (ResourceDirectory)object;
                dir.applyRule(rule, finalAppliedAtParent);
            }
        });
    }

    public List<ResourceRule> createRules(ResourceDirectory compareRoot) {
        return this.createRules(compareRoot, null);
    }

    private List<ResourceRule> createRules(ResourceDirectory compareRoot, ResourceAction ignoreRulesWith) {
        ResourceAction compActionForRule;
        ArrayList<ResourceRule> rules = new ArrayList<ResourceRule>();
        Optional<ResourceDirectory> compDir = compareRoot.findDirectory(this.location());
        ResourceAction ruleAction = this.actionForRule();
        if (compDir.isPresent() && (compActionForRule = compDir.get().ruleAction()) != null && compActionForRule != ignoreRulesWith && (ignoreRulesWith != null || !Objects.equals((Object)compActionForRule, (Object)ruleAction))) {
            rules.add(new ResourceRule(compDir.get()));
            ignoreRulesWith = compActionForRule;
        }
        ResourceAction finalIgnoreRulesWith = ignoreRulesWith;
        this.children().forEach(object -> {
            if (object instanceof ResourceFile) {
                ResourceAction compFileActionForRule;
                ResourceFile file = (ResourceFile)object;
                Optional<ResourceFile> compFile = compareRoot.findFile(file.location());
                if (compFile.isPresent() && (compFileActionForRule = compFile.get().actionForRule()) != finalIgnoreRulesWith && (finalIgnoreRulesWith != null || !compFileActionForRule.equals((Object)file.actionForRule()))) {
                    rules.add(new ResourceRule(compFile.get()));
                }
            } else if (object instanceof ResourceDirectory) {
                ResourceDirectory dir = (ResourceDirectory)object;
                rules.addAll(dir.createRules(compareRoot, finalIgnoreRulesWith));
            }
        });
        return rules;
    }

    @Override
    protected void printTree(int tabIndex) {
        System.out.println("\t".repeat(tabIndex) + this.location().toString());
        this.children().forEach(resourceObject -> resourceObject.printTree(tabIndex + 1));
    }

    @Override
    public class_2561 getLabel(@Nullable ResourceDirectory parent) {
        String renderedText = this.location().toString().substring(Optional.ofNullable(parent).map(dir -> dir.location().toString().length()).orElse(0));
        if (renderedText.startsWith("/")) {
            renderedText = renderedText.substring(1);
        }
        return class_2561.method_43470((String)renderedText).method_27692(class_124.field_1080);
    }

    public void addChild(ResourceObject object) {
        this.children().add(object);
    }

    private void removeEmptyDirectories() {
        this.children().removeIf(resourceObject -> {
            ResourceDirectory resourceDirectory;
            return resourceObject instanceof ResourceDirectory && !(resourceDirectory = (ResourceDirectory)resourceObject).containsFiles();
        });
    }

    private void flatten() {
        ResourceObject resourceObject;
        this.removeEmptyDirectories();
        if (this.children().size() == 1 && (resourceObject = this.children.get(0)) instanceof ResourceDirectory) {
            ResourceDirectory childDir = (ResourceDirectory)resourceObject;
            this.location(childDir.location());
            this.children().clear();
            this.children().addAll(childDir.children());
        }
        this.removeEmptyDirectories();
    }

    private void sort() {
        this.children().sort((o1, o2) -> {
            if (o1.getClass().equals(o2.getClass())) {
                return o1.location().toString().compareTo(o2.location().toString());
            }
            if (o1 instanceof ResourceDirectory && !(o2 instanceof ResourceDirectory)) {
                return -1;
            }
            return 1;
        });
    }

    public void flattenSort() {
        this.flatten();
        for (ResourceObject child : this.children()) {
            if (!(child instanceof ResourceDirectory)) continue;
            ResourceDirectory childDir = (ResourceDirectory)child;
            childDir.flattenSort();
        }
        this.sort();
    }

    public ResourceDirectory filter(Predicate<ResourceObject> predicate) {
        ResourceDirectory clone = this.clone();
        clone.children().removeIf(predicate.negate());
        List<ResourceObject> newObjects = clone.children().stream().map(resourceObject -> {
            if (resourceObject instanceof ResourceDirectory) {
                ResourceDirectory resourceDirectory = (ResourceDirectory)resourceObject;
                return resourceDirectory.filter(predicate);
            }
            return resourceObject;
        }).toList();
        clone.children().clear();
        clone.children().addAll(newObjects);
        return clone;
    }

    @Override
    public ResourceAction action() {
        if (this.children().isEmpty()) {
            return null;
        }
        ResourceAction action = this.children().get(0).action();
        if (action == null) {
            return null;
        }
        for (int i = 1; i < this.children().size(); ++i) {
            if (this.children().get(i).action() == action) continue;
            return null;
        }
        return action;
    }

    @Override
    public ResourceAction actionForRule() {
        if (this.ruleAction() != null) {
            return this.ruleAction();
        }
        return super.actionForRule();
    }

    @Override
    public void action(ResourceAction action) {
        this.children().forEach(object -> object.action(action));
    }

    @Override
    public boolean supportsMerging() {
        return this.children().stream().allMatch(ResourceObject::supportsMerging);
    }

    public boolean containsFiles() {
        if (this.children().isEmpty()) {
            return false;
        }
        return this.children().stream().anyMatch(resourceObject -> {
            if (resourceObject instanceof ResourceDirectory) {
                ResourceDirectory resourceDirectory = (ResourceDirectory)resourceObject;
                return resourceDirectory.containsFiles();
            }
            return true;
        });
    }

    @Override
    public ResourceDirectory clone() {
        ResourceDirectory clone = new ResourceDirectory(this.location());
        clone.children().addAll(this.children().stream().map(ResourceObject::clone).toList());
        return clone;
    }

    public List<ResourceObject> children() {
        return this.children;
    }

    public ResourceAction ruleAction() {
        return this.ruleAction;
    }

    public ResourceDirectory ruleAction(ResourceAction ruleAction) {
        this.ruleAction = ruleAction;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceDirectory)) {
            return false;
        }
        ResourceDirectory other = (ResourceDirectory)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        List<ResourceObject> this$children = this.children();
        List<ResourceObject> other$children = other.children();
        return !(this$children == null ? other$children != null : !((Object)this$children).equals(other$children));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ResourceDirectory;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        List<ResourceObject> $children = this.children();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        return result;
    }
}

