/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack.config.resource;

import dev.kinau.myresourcepack.config.ResourceAction;
import dev.kinau.myresourcepack.config.resource.ResourceDirectory;
import dev.kinau.myresourcepack.config.resource.ResourceObject;
import dev.kinau.myresourcepack.utils.ResourceBlockingUtils;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class ResourceFile
extends ResourceObject
implements Cloneable {
    private ResourceAction action;
    private final boolean overridesVanilla;

    public ResourceFile(class_2960 location, ResourceAction action, boolean overridesVanilla) {
        super(location);
        this.action = action;
        this.overridesVanilla = overridesVanilla;
    }

    @Override
    public void action(ResourceAction action) {
        this.action = action;
    }

    @Override
    protected void printTree(int tabIndex) {
        System.out.println("\t".repeat(tabIndex) + this.location().toString());
    }

    @Override
    public class_2561 getLabel(ResourceDirectory parent) {
        String renderedText = this.location().toString().substring(Optional.ofNullable(parent).map(dir -> dir.location().toString().length()).orElse(0));
        if (renderedText.startsWith("/")) {
            renderedText = renderedText.substring(1);
        }
        return class_2561.method_43470((String)renderedText).method_27692(class_124.field_1068);
    }

    @Override
    public boolean supportsMerging() {
        return ResourceBlockingUtils.supportsMerging(this.location());
    }

    @Override
    public ResourceFile clone() {
        return new ResourceFile(this.location(), this.action(), this.overridesVanilla());
    }

    @Override
    public ResourceAction action() {
        return this.action;
    }

    public boolean overridesVanilla() {
        return this.overridesVanilla;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ResourceFile)) {
            return false;
        }
        ResourceFile other = (ResourceFile)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ResourceAction this$action = this.action();
        ResourceAction other$action = other.action();
        return !(this$action == null ? other$action != null : !((Object)((Object)this$action)).equals((Object)other$action));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof ResourceFile;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ResourceAction $action = this.action();
        result = result * 59 + ($action == null ? 43 : ((Object)((Object)$action)).hashCode());
        return result;
    }
}

