/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack.mixin;

import dev.kinau.myresourcepack.config.ResourceAction;
import dev.kinau.myresourcepack.config.VanillaResourceAction;
import dev.kinau.myresourcepack.config.resource.ResourceDirectory;
import dev.kinau.myresourcepack.config.resource.ResourceFile;
import dev.kinau.myresourcepack.expander.PackResourceExpander;
import dev.kinau.myresourcepack.utils.ResourceBlockingUtils;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Optional;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.minecraft.class_2960;
import net.minecraft.class_3258;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_3258.class})
public abstract class FilePackResourcesMixin
implements PackResourceExpander {
    @Shadow
    @Final
    private class_3258.class_8616 field_45038;

    private static String myResourcePack$getPathFromLocation(class_3264 packType, class_2960 identifier) {
        return String.format(Locale.ROOT, "%s/%s/%s", packType.method_14413(), identifier.method_12836(), identifier.method_12832());
    }

    @Shadow
    protected abstract String method_52422(String var1);

    @Inject(method={"method_14405*(Lnet/minecraft/class_3264;Lnet/minecraft/class_2960;)Lnet/minecraft/class_7367;"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetResource(class_3264 packType, class_2960 identifier, CallbackInfoReturnable<class_7367<InputStream>> cir) {
        ResourceAction action;
        if (!ResourceBlockingUtils.isBlockingEnabled()) {
            return;
        }
        if (((class_3258)this).method_14409().startsWith("server/") && packType == class_3264.field_14188 && (action = ResourceBlockingUtils.getConfiguredResourceAction(identifier)) != ResourceAction.PASS) {
            if (action == ResourceAction.MERGE) {
                ZipFile zipFile = this.field_45038.method_52426();
                if (zipFile == null) {
                    cir.setReturnValue(null);
                    return;
                }
                ZipEntry zipEntry = zipFile.getEntry(this.method_52422(FilePackResourcesMixin.myResourcePack$getPathFromLocation(packType, identifier)));
                if (zipEntry == null) {
                    cir.setReturnValue(null);
                    return;
                }
                cir.setReturnValue(ResourceBlockingUtils.mergeData(identifier, (class_7367<InputStream>)class_7367.create((ZipFile)zipFile, (ZipEntry)zipEntry)));
                return;
            }
            cir.cancel();
            return;
        }
    }

    @Inject(method={"method_14408(Lnet/minecraft/class_3264;Ljava/lang/String;Ljava/lang/String;Lnet/minecraft/class_3262$class_7664;)V"}, at={@At(value="HEAD")}, cancellable=true)
    private void onListResources(class_3264 packType, String namespace, String path, class_3262.class_7664 resourceOutput, CallbackInfo ci) {
        if (!ResourceBlockingUtils.isBlockingEnabled()) {
            return;
        }
        if (((class_3258)this).method_14409().startsWith("server/") && packType == class_3264.field_14188) {
            try {
                ZipFile zipFile = this.field_45038.method_52426();
                if (zipFile == null) {
                    return;
                }
                Enumeration<? extends ZipEntry> enumeration = zipFile.entries();
                String string3 = this.method_52422(packType.method_14413() + "/" + namespace + "/");
                String string4 = string3 + path + "/";
                while (enumeration.hasMoreElements()) {
                    String string6;
                    class_2960 identifier;
                    String string5;
                    ZipEntry zipEntry = enumeration.nextElement();
                    if (zipEntry.isDirectory() || !(string5 = zipEntry.getName()).startsWith(string4) || (identifier = class_2960.method_43902((String)namespace, (String)(string6 = string5.substring(string3.length())))) == null) continue;
                    Optional<Object> resource = Optional.empty();
                    ResourceAction action = ResourceBlockingUtils.getConfiguredResourceAction(identifier);
                    if (action != ResourceAction.PASS) {
                        if (action != ResourceAction.MERGE) continue;
                        resource = Optional.of(ResourceBlockingUtils.mergeData(identifier, (class_7367<InputStream>)class_7367.create((ZipFile)zipFile, (ZipEntry)zipEntry)));
                    }
                    resourceOutput.accept((Object)identifier, (Object)resource.orElse(class_7367.create((ZipFile)zipFile, (ZipEntry)zipEntry)));
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ci.cancel();
        }
    }

    @Override
    public ResourceDirectory myResourcePack$createResourceTree(class_3264 packType, String namespace) {
        ZipFile zipFile = this.field_45038.method_52426();
        ResourceDirectory root = new ResourceDirectory(class_2960.method_60655((String)namespace, (String)""));
        if (zipFile == null) {
            return root;
        }
        Enumeration<? extends ZipEntry> entries = zipFile.entries();
        String prefixedNamespace = this.method_52422(packType.method_14413() + "/" + namespace);
        while (entries.hasMoreElements()) {
            String currName;
            ZipEntry zipEntry = entries.nextElement();
            if (zipEntry.isDirectory() || !(currName = zipEntry.getName()).startsWith(prefixedNamespace)) continue;
            String pathWithoutNamespace = currName.substring(prefixedNamespace.length());
            String[] parts = pathWithoutNamespace.split("/");
            if (pathWithoutNamespace.startsWith("/")) {
                pathWithoutNamespace = pathWithoutNamespace.substring(1);
            }
            ResourceDirectory currentDir = root;
            for (int i = 0; i < parts.length - 1; ++i) {
                if (parts[i].isEmpty()) continue;
                currentDir = currentDir.getOrCreateDir(parts[i]);
            }
            class_2960 identifier = class_2960.method_43902((String)namespace, (String)pathWithoutNamespace);
            if (currentDir == null || identifier == null) continue;
            VanillaResourceAction action = ResourceBlockingUtils.getDefaultResourceAction(identifier);
            currentDir.children().add(new ResourceFile(identifier, action.action(), action.overridesVanilla()));
        }
        return root;
    }
}

