/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack.screen;

import dev.kinau.myresourcepack.MyResourcePack;
import dev.kinau.myresourcepack.config.ResourceRule;
import dev.kinau.myresourcepack.config.ResourceTab;
import dev.kinau.myresourcepack.config.resource.ResourceDirectory;
import dev.kinau.myresourcepack.config.resource.ResourceFile;
import dev.kinau.myresourcepack.screen.components.tab.TreeViewTab;
import dev.kinau.myresourcepack.screen.components.treeview.TreeView;
import dev.kinau.myresourcepack.utils.ResourceBlockingUtils;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.class_10799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_350;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_8021;
import net.minecraft.class_8030;
import net.minecraft.class_8087;
import net.minecraft.class_8088;
import net.minecraft.class_8089;
import net.minecraft.class_8132;
import net.minecraft.class_8667;
import org.jetbrains.annotations.Nullable;

public class ResourceSelectionScreen
extends class_437 {
    public static final class_2960 TAB_HEADER_BACKGROUND = class_2960.method_60656((String)"textures/gui/tab_header_background.png");
    protected final ResourceDirectory rootDirectory;
    protected final class_437 lastScreen;
    protected ResourceDirectory prevOverriddenDirectory;
    protected ResourceDirectory prevAdditionalDirectory;
    protected ResourceDirectory overriddenDirectory;
    protected ResourceDirectory additionalDirectory;
    private final class_8088 tabManager = new class_8088(x$0 -> {
        class_339 cfr_ignored_0 = (class_339)this.method_37063((class_364)x$0);
    }, x$0 -> this.method_37066((class_364)x$0));
    private final class_8132 layout = new class_8132((class_437)this);
    @Nullable
    private class_8089 tabNavigationBar;

    public ResourceSelectionScreen(class_437 lastScreen, ResourceDirectory rootDirectory) {
        super((class_2561)class_2561.method_43471((String)"enable_resource_blocking"));
        this.rootDirectory = rootDirectory;
        this.lastScreen = lastScreen;
    }

    private void closeScreen() {
        if (this.field_22787 == null) {
            return;
        }
        this.field_22787.method_1507(this.lastScreen);
    }

    private TreeViewTab createTab(ResourceTab tab, ResourceDirectory rootDirectory) {
        return new TreeViewTab(tab.getTitle(), (class_350<?>)new TreeView(this.field_22787, this.field_22789, this.layout, tab, rootDirectory), () -> this.field_22789, this.layout);
    }

    private void applySelectedRules(ResourceDirectory directory) {
        if (directory == this.overriddenDirectory) {
            ResourceBlockingUtils.getServerSetting().ifPresent(serverSetting -> serverSetting.overrideRules().forEach(directory::applyRule));
        } else if (directory == this.additionalDirectory) {
            ResourceBlockingUtils.getServerSetting().ifPresent(serverSetting -> serverSetting.additionRules().forEach(directory::applyRule));
        }
    }

    private boolean hasChanges() {
        return !this.prevAdditionalDirectory.equals(this.additionalDirectory) || !this.prevOverriddenDirectory.equals(this.overriddenDirectory);
    }

    private void reloadAndClose() {
        if (this.field_22787 != null) {
            this.field_22787.method_1521().thenAccept(unused -> this.closeScreen());
        } else {
            this.closeScreen();
        }
    }

    private void done() {
        if (this.hasChanges()) {
            ResourceBlockingUtils.getServerSetting().ifPresent(serverSetting -> {
                serverSetting.overrideRules(this.rootDirectory.createRules(this.overriddenDirectory));
                serverSetting.additionRules(this.rootDirectory.createRules(this.additionalDirectory));
                try {
                    MyResourcePack.getInstance().getPackSettings().saveConfig();
                }
                catch (IOException e) {
                    MyResourcePack.LOGGER.error("Could not save config", (Throwable)e);
                }
            });
            this.reloadAndClose();
            return;
        }
        this.closeScreen();
    }

    public void method_25419() {
        this.done();
    }

    protected void method_25426() {
        this.overriddenDirectory = this.rootDirectory.clone().filter(resourceObject -> {
            ResourceFile resourceFile;
            if (resourceObject instanceof ResourceDirectory) {
                return true;
            }
            return resourceObject instanceof ResourceFile && (resourceFile = (ResourceFile)resourceObject).overridesVanilla();
        });
        this.applySelectedRules(this.overriddenDirectory);
        this.overriddenDirectory.flattenSort();
        this.prevOverriddenDirectory = this.overriddenDirectory.clone();
        this.additionalDirectory = this.rootDirectory.clone().filter(resourceObject -> {
            ResourceFile resourceFile;
            if (resourceObject instanceof ResourceDirectory) {
                return true;
            }
            return resourceObject instanceof ResourceFile && !(resourceFile = (ResourceFile)resourceObject).overridesVanilla();
        });
        this.applySelectedRules(this.additionalDirectory);
        this.additionalDirectory.flattenSort();
        this.prevAdditionalDirectory = this.additionalDirectory.clone();
        this.tabNavigationBar = class_8089.method_48623((class_8088)this.tabManager, (int)this.field_22789).method_48631(new class_8087[]{this.createTab(ResourceTab.OVERRIDE, this.overriddenDirectory), this.createTab(ResourceTab.ADDITION, this.additionalDirectory)}).method_48627();
        this.method_37063((class_364)this.tabNavigationBar);
        class_8667 footerLayout = (class_8667)this.layout.method_48996((class_8021)class_8667.method_52742().method_52735(8));
        footerLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_2561.method_43471((String)"resourceSelectionScreen.reset"), button -> {
            ResourceBlockingUtils.getServerSetting().ifPresent(serverSetting -> {
                serverSetting.overrideRules(new ArrayList<ResourceRule>());
                serverSetting.additionRules(new ArrayList<ResourceRule>());
                try {
                    MyResourcePack.getInstance().getPackSettings().saveConfig();
                }
                catch (IOException e) {
                    MyResourcePack.LOGGER.error("Could not save config", (Throwable)e);
                }
            });
            this.reloadAndClose();
        }).method_46431());
        footerLayout.method_52736((class_8021)class_4185.method_46430((class_2561)class_5244.field_24334, button -> this.done()).method_46431());
        this.layout.method_48206(widget -> {
            widget.method_48591(1);
            this.method_37063((class_364)widget);
        });
        this.tabNavigationBar.method_48987(0, false);
        this.method_48640();
    }

    public void method_48640() {
        if (this.tabNavigationBar != null) {
            this.tabNavigationBar.method_48618(this.field_22789);
            this.tabNavigationBar.method_49613();
            int var0 = this.tabNavigationBar.method_48202().method_49619();
            class_8030 var1 = new class_8030(0, var0, this.field_22789, this.field_22790 - this.layout.method_48994() - var0);
            this.tabManager.method_48616(var1);
            this.layout.method_48995(var0);
            this.layout.method_48222();
        }
    }

    public void method_25394(class_332 graphics, int x, int y, float gameTime) {
        super.method_25394(graphics, x, y, gameTime);
        graphics.method_25290(class_10799.field_56883, class_437.field_49896, 0, this.field_22790 - this.layout.method_48994() - 2, 0.0f, 0.0f, this.field_22789, 2, 32, 2);
    }

    protected void method_57735(class_332 param0) {
        param0.method_25290(class_10799.field_56883, TAB_HEADER_BACKGROUND, 0, 0, 0.0f, 0.0f, this.field_22789, this.layout.method_48998(), 16, 16);
        this.method_57736(param0, 0, this.layout.method_48998(), this.field_22789, this.field_22790);
    }
}

