/*
 * Decompiled with CFR 0.152.
 */
package dev.kinau.myresourcepack.utils;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.stream.JsonReader;
import dev.kinau.myresourcepack.MyResourcePack;
import dev.kinau.myresourcepack.config.ResourceAction;
import dev.kinau.myresourcepack.config.ResourceRule;
import dev.kinau.myresourcepack.config.ServerSetting;
import dev.kinau.myresourcepack.config.VanillaResourceAction;
import dev.kinau.myresourcepack.utils.GsonTools;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_7367;

public class ResourceBlockingUtils {
    public static boolean isBlockingEnabled() {
        String currentServer = MyResourcePack.getInstance().getCurrentServer();
        if (currentServer == null) {
            return false;
        }
        return !MyResourcePack.getInstance().getPackSettings().getConfigData().getSettings(currentServer).overrideTextures();
    }

    public static boolean supportsMerging(class_2960 identifier) {
        if (identifier == null) {
            return false;
        }
        return identifier.method_12832().endsWith(".json");
    }

    public static Optional<ServerSetting> getServerSetting() {
        String currentServer = MyResourcePack.getInstance().getCurrentServer();
        if (currentServer == null) {
            return Optional.empty();
        }
        return Optional.of(MyResourcePack.getInstance().getPackSettings().getConfigData().getSettings(currentServer));
    }

    public static ResourceAction getConfiguredResourceAction(class_2960 identifier) {
        Optional<ServerSetting> optSettings = ResourceBlockingUtils.getServerSetting();
        if (optSettings.isEmpty()) {
            return ResourceAction.PASS;
        }
        ServerSetting setting = optSettings.get();
        if (setting.overrideTextures()) {
            return ResourceAction.PASS;
        }
        String path = identifier.toString();
        VanillaResourceAction resourceAction = ResourceBlockingUtils.getDefaultResourceAction(identifier);
        List<ResourceRule> rules = resourceAction.overridesVanilla() ? setting.overrideRules() : setting.additionRules();
        for (int i = rules.size() - 1; i >= 0; --i) {
            ResourceRule rule = rules.get(i);
            if (!rule.matches(path)) continue;
            return rule.action();
        }
        return resourceAction.action();
    }

    public static VanillaResourceAction getDefaultResourceAction(class_2960 identifier) {
        if (!identifier.method_12836().equals("minecraft")) {
            return new VanillaResourceAction(ResourceAction.PASS, false);
        }
        boolean overridesVanilla = true;
        try (class_3262 vanillaResource = class_310.method_1551().method_1520().method_14449("vanilla").method_14458();){
            if (vanillaResource.method_14405(class_3264.field_14188, identifier) == null) {
                if (identifier.method_12832().endsWith(".mcmeta")) {
                    class_2960 baseLoc = class_2960.method_43902((String)identifier.method_12836(), (String)identifier.method_12832().substring(0, identifier.method_12832().length() - ".mcmeta".length()));
                    if (vanillaResource.method_14405(class_3264.field_14188, baseLoc) == null) {
                        overridesVanilla = false;
                    }
                } else {
                    overridesVanilla = false;
                }
            }
        }
        if (identifier.method_12832().startsWith("shaders/") || identifier.method_12832().startsWith("post_effect/")) {
            return new VanillaResourceAction(ResourceAction.PASS, overridesVanilla);
        }
        if (identifier.method_12832().startsWith("atlases/")) {
            return new VanillaResourceAction(ResourceAction.PASS, overridesVanilla);
        }
        if (identifier.method_12832().startsWith("blockstates/")) {
            return new VanillaResourceAction(ResourceAction.PASS, overridesVanilla);
        }
        if (identifier.method_12832().startsWith("textures/gui/sprites/boss_bar/")) {
            return new VanillaResourceAction(ResourceAction.PASS, overridesVanilla);
        }
        if (identifier.method_12832().startsWith("textures/misc/pumpkinblur.png")) {
            return new VanillaResourceAction(ResourceAction.PASS, overridesVanilla);
        }
        if (overridesVanilla) {
            if (identifier.method_12832().startsWith("font/")) {
                return identifier.method_12832().equals("include/unifont.zip") ? new VanillaResourceAction(ResourceAction.BLOCK, true) : new VanillaResourceAction(ResourceAction.PASS, true);
            }
            if (identifier.method_12832().startsWith("lang/")) {
                return new VanillaResourceAction(ResourceAction.MERGE, true);
            }
            if (identifier.method_12832().startsWith("items/")) {
                return new VanillaResourceAction(ResourceAction.MERGE, true);
            }
            if (identifier.method_12832().equals("sounds.json")) {
                return new VanillaResourceAction(ResourceAction.MERGE, true);
            }
        }
        return overridesVanilla ? new VanillaResourceAction(ResourceAction.BLOCK, true) : new VanillaResourceAction(ResourceAction.PASS, false);
    }

    private static ModelTextureData getModelTextures(InputStream inputStream) {
        JsonObject rootObj;
        if (inputStream == null) {
            return null;
        }
        JsonElement element = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(inputStream)));
        if (element.isJsonObject() && (rootObj = element.getAsJsonObject()).has("textures") && rootObj.get("textures").isJsonObject()) {
            JsonObject textures = rootObj.getAsJsonObject("textures");
            return new ModelTextureData(rootObj, textures);
        }
        return null;
    }

    private static ItemModelData getItemModelData(InputStream inputStream) {
        JsonObject model;
        JsonObject rootObj;
        if (inputStream == null) {
            return null;
        }
        JsonElement element = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(inputStream)));
        if (element.isJsonObject() && (rootObj = element.getAsJsonObject()).has("model") && rootObj.get("model").isJsonObject() && (model = rootObj.getAsJsonObject("model")).has("type") && model.get("type").isJsonPrimitive() && model.get("type").getAsJsonPrimitive().isString()) {
            return new ItemModelData(rootObj, model, model.getAsJsonPrimitive("type").getAsString().replace("minecraft:", ""));
        }
        return null;
    }

    public static class_7367<InputStream> mergeModelData(class_2960 identifier, class_7367<InputStream> original) {
        return () -> {
            try {
                block12: {
                    class_3262 vanillaResource;
                    block10: {
                        ByteArrayInputStream byteArrayInputStream;
                        block11: {
                            ModelTextureData textures = ResourceBlockingUtils.getModelTextures((InputStream)original.get());
                            if (textures == null) break block12;
                            vanillaResource = class_310.method_1551().method_1520().method_14449("vanilla").method_14458();
                            try {
                                ModelTextureData vanillaTextures = ResourceBlockingUtils.getModelTextures((InputStream)vanillaResource.method_14405(class_3264.field_14188, identifier).get());
                                if (textures.textures().equals((Object)vanillaTextures.textures())) break block10;
                                JsonObject root = textures.root();
                                GsonTools.extendJsonObject(vanillaTextures.textures(), GsonTools.ConflictStrategy.PREFER_FIRST_OBJ, textures.textures());
                                root.add("textures", (JsonElement)vanillaTextures.textures());
                                byteArrayInputStream = new ByteArrayInputStream(root.toString().getBytes(StandardCharsets.UTF_8));
                                if (vanillaResource == null) break block11;
                            }
                            catch (Throwable throwable) {
                                if (vanillaResource != null) {
                                    try {
                                        vanillaResource.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            vanillaResource.close();
                        }
                        return byteArrayInputStream;
                    }
                    if (vanillaResource != null) {
                        vanillaResource.close();
                    }
                    break;
                }
            }
            finally {
                return (InputStream)original.get();
            }
        };
    }

    public static class_7367<InputStream> mergeItemsData(class_2960 identifier, class_7367<InputStream> original) {
        return () -> {
            try {
                ItemModelData itemData = ResourceBlockingUtils.getItemModelData((InputStream)original.get());
                if (itemData == null) return (InputStream)original.get();
                try (class_3262 vanillaResource = class_310.method_1551().method_1520().method_14449("vanilla").method_14458();){
                    ItemModelData vanillaItemData = ResourceBlockingUtils.getItemModelData((InputStream)vanillaResource.method_14405(class_3264.field_14188, identifier).get());
                    if (itemData.modelType().equals("range_dispatch") || itemData.modelType().equals("select")) {
                        JsonObject fallback = vanillaItemData.model();
                        itemData.model().add("fallback", (JsonElement)fallback);
                        itemData.root().add("model", (JsonElement)itemData.model());
                    } else {
                        itemData.root().add("model", (JsonElement)vanillaItemData.model());
                    }
                    ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(itemData.root().toString().getBytes(StandardCharsets.UTF_8));
                    return byteArrayInputStream;
                }
            }
            catch (Throwable e) {
                return (InputStream)original.get();
            }
        };
    }

    private static JsonObject getJsonData(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        JsonElement element = JsonParser.parseReader((JsonReader)new JsonReader((Reader)new InputStreamReader(inputStream)));
        if (element.isJsonObject()) {
            return element.getAsJsonObject();
        }
        return null;
    }

    private static class_7367<InputStream> mergeJsonData(class_2960 identifier, class_7367<InputStream> original) {
        return () -> {
            try {
                block12: {
                    class_3262 vanillaResource;
                    block10: {
                        ByteArrayInputStream byteArrayInputStream;
                        block11: {
                            JsonObject jsonData = ResourceBlockingUtils.getJsonData((InputStream)original.get());
                            if (jsonData == null) break block12;
                            vanillaResource = class_310.method_1551().method_1520().method_14449("vanilla").method_14458();
                            try {
                                JsonObject vanillaJsonData = ResourceBlockingUtils.getJsonData((InputStream)vanillaResource.method_14405(class_3264.field_14188, identifier).get());
                                if (vanillaJsonData == null) break block10;
                                GsonTools.extendJsonObject(jsonData, GsonTools.ConflictStrategy.PREFER_SECOND_OBJ, vanillaJsonData);
                                byteArrayInputStream = new ByteArrayInputStream(jsonData.toString().getBytes(StandardCharsets.UTF_8));
                                if (vanillaResource == null) break block11;
                            }
                            catch (Throwable throwable) {
                                if (vanillaResource != null) {
                                    try {
                                        vanillaResource.close();
                                    }
                                    catch (Throwable throwable2) {
                                        throwable.addSuppressed(throwable2);
                                    }
                                }
                                throw throwable;
                            }
                            vanillaResource.close();
                        }
                        return byteArrayInputStream;
                    }
                    if (vanillaResource != null) {
                        vanillaResource.close();
                    }
                    break;
                }
            }
            finally {
                return (InputStream)original.get();
            }
        };
    }

    public static class_7367<InputStream> mergeData(class_2960 identifier, class_7367<InputStream> original) {
        if (identifier.method_12832().startsWith("models/") && identifier.method_12832().endsWith(".json")) {
            return ResourceBlockingUtils.mergeModelData(identifier, original);
        }
        if (identifier.method_12832().startsWith("lang/") && identifier.method_12832().endsWith(".json")) {
            return ResourceBlockingUtils.mergeJsonData(identifier, original);
        }
        if (identifier.method_12832().equals("sounds.json")) {
            return ResourceBlockingUtils.mergeJsonData(identifier, original);
        }
        if (identifier.method_12832().startsWith("items/") && identifier.method_12832().endsWith(".json")) {
            return ResourceBlockingUtils.mergeItemsData(identifier, original);
        }
        return original;
    }

    record ModelTextureData(JsonObject root, JsonObject textures) {
    }

    record ItemModelData(JsonObject root, JsonObject model, String modelType) {
    }
}

