/*
 * Decompiled with CFR 0.152.
 */
package com.samxel.deathscut;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Random;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.common.NeoForge;
import net.neoforged.neoforge.event.entity.living.LivingDeathEvent;

@Mod(value="deathscut")
public class DeathsCut {
    public static final String MODID = "deathscut";

    public DeathsCut() {
        NeoForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerDeath(LivingDeathEvent event) {
        ServerLevel serverLevel;
        boolean keepInventory;
        LivingEntity livingEntity = event.getEntity();
        if (!(livingEntity instanceof Player)) {
            return;
        }
        Player player = (Player)livingEntity;
        if (player.level().isClientSide()) {
            return;
        }
        Level level = player.level();
        if (level instanceof ServerLevel && (keepInventory = (serverLevel = (ServerLevel)level).getGameRules().getBoolean(GameRules.RULE_KEEPINVENTORY))) {
            return;
        }
        ArrayList<ItemStack> allItems = new ArrayList<ItemStack>();
        Inventory inv = player.getInventory();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack s = inv.getItem(i);
            if (s.isEmpty()) continue;
            allItems.add(s);
        }
        if (allItems.isEmpty()) {
            return;
        }
        Random jrand = new Random(player.getRandom().nextLong());
        Collections.shuffle(allItems, jrand);
        int half = allItems.size() / 2;
        ArrayList toDrop = new ArrayList(allItems.subList(0, half));
        inv.clearContent();
        for (ItemStack stack : toDrop) {
            if (stack.isEmpty()) continue;
            ItemEntity entity = new ItemEntity(player.level(), player.getX(), player.getY() + 0.5, player.getZ(), stack);
            entity.setDefaultPickUpDelay();
            player.level().addFreshEntity((Entity)entity);
        }
    }
}

