/*
 * Decompiled with CFR 0.152.
 */
package sleepbetter.mamtak.betterSleep;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import net.md_5.bungee.api.ChatMessageType;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Monster;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerBedEnterEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;

public final class BetterSleep
extends JavaPlugin
implements Listener,
CommandExecutor,
TabCompleter {
    private int neededPlayers;

    public void onEnable() {
        this.saveDefaultConfig();
        this.reloadConfig();
        this.neededPlayers = this.getConfig().getInt("players-needed", 1);
        this.getServer().getPluginManager().registerEvents((Listener)this, (Plugin)this);
        Objects.requireNonNull(this.getCommand("sleep")).setExecutor((CommandExecutor)this);
        this.getCommand("sleep").setTabCompleter((TabCompleter)this);
    }

    public void onDisable() {
    }

    @EventHandler
    public void onBedEnter(PlayerBedEnterEvent e) {
        boolean isNight;
        Player p = e.getPlayer();
        final World w = p.getWorld();
        long time = w.getTime();
        Location bedCenter = e.getBed().getLocation().clone().add(0.5, 0.5, 0.5);
        boolean bl = isNight = time >= 12541L && time <= 23458L;
        if (!isNight && !w.hasStorm()) {
            e.setCancelled(true);
            p.sendMessage(String.valueOf(ChatColor.RED) + "You can only sleep at night or during a thunderstorm.");
            return;
        }
        if (p.getLocation().distance(bedCenter) > 8.0) {
            e.setCancelled(true);
            p.sendMessage(String.valueOf(ChatColor.RED) + "You are too far from the bed to sleep.");
            return;
        }
        boolean monsterNearby = w.getNearbyEntities(p.getLocation(), 8.0, 5.0, 8.0).stream().anyMatch(ent -> ent instanceof Monster);
        if (monsterNearby) {
            e.setCancelled(true);
            p.sendMessage(String.valueOf(ChatColor.RED) + "You cannot sleep with monsters nearby.");
            return;
        }
        new BukkitRunnable(){

            public void run() {
                long sleeping = w.getPlayers().stream().filter(LivingEntity::isSleeping).count();
                String bar = String.valueOf(ChatColor.WHITE) + sleeping + String.valueOf(ChatColor.GRAY) + "/" + String.valueOf(ChatColor.WHITE) + BetterSleep.this.neededPlayers + String.valueOf(ChatColor.GRAY) + " players sleeping";
                TextComponent tc = new TextComponent(bar);
                w.getPlayers().forEach(pl -> pl.spigot().sendMessage(ChatMessageType.ACTION_BAR, (BaseComponent)tc));
                if (sleeping >= (long)BetterSleep.this.neededPlayers) {
                    new BukkitRunnable(){

                        public void run() {
                            w.setTime(0L);
                            w.getPlayers().stream().filter(LivingEntity::isSleeping).forEach(pl -> pl.wakeup(true));
                        }
                    }.runTaskLater((Plugin)BetterSleep.this, 20L);
                }
            }
        }.runTask((Plugin)this);
    }

    public boolean onCommand(CommandSender s, Command cmd, String label, String[] args) {
        if (!s.isOp()) {
            s.sendMessage(String.valueOf(ChatColor.RED) + "You don\u2019t have permission.");
            return true;
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("Players") && args[1].equalsIgnoreCase("set")) {
            try {
                int v = Integer.parseInt(args[2]);
                if (v < 1) {
                    throw new NumberFormatException();
                }
                this.getConfig().set("players-needed", (Object)v);
                this.saveConfig();
                this.neededPlayers = v;
                s.sendMessage(String.valueOf(ChatColor.GREEN) + "Sleep threshold set to " + v + " player" + (v > 1 ? "s." : "."));
            }
            catch (NumberFormatException ex) {
                s.sendMessage(String.valueOf(ChatColor.RED) + "Use a positive number.");
            }
            return true;
        }
        if (args.length == 1 && args[0].equalsIgnoreCase("reload")) {
            this.reloadConfig();
            this.neededPlayers = this.getConfig().getInt("players-needed", 1);
            s.sendMessage(String.valueOf(ChatColor.GREEN) + "Config reloaded. Threshold is " + this.neededPlayers + ".");
            return true;
        }
        s.sendMessage(String.valueOf(ChatColor.YELLOW) + "Usage:");
        s.sendMessage(String.valueOf(ChatColor.YELLOW) + "/sleep Players set <number>");
        s.sendMessage(String.valueOf(ChatColor.YELLOW) + "/sleep reload");
        return true;
    }

    public List<String> onTabComplete(CommandSender s, Command cmd, String alias, String[] args) {
        if (args.length == 1) {
            return Arrays.asList("Players", "reload");
        }
        if (args.length == 2 && args[0].equalsIgnoreCase("Players")) {
            return Collections.singletonList("set");
        }
        if (args.length == 3 && args[0].equalsIgnoreCase("Players") && args[1].equalsIgnoreCase("set")) {
            ArrayList<String> nums = new ArrayList<String>();
            for (int i = 1; i <= 10; ++i) {
                nums.add(String.valueOf(i));
            }
            return nums;
        }
        return Collections.emptyList();
    }
}

