/*
 * Decompiled with CFR 0.152.
 */
package magicjinn.theblockkeepsticking;

import com.mojang.serialization.Codec;
import magicjinn.theblockkeepsticking.config.ModConfig;
import magicjinn.theblockkeepsticking.simulator.WorldSimulator;
import magicjinn.theblockkeepsticking.util.Timer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerChunkEvents;
import net.minecraft.class_2960;
import net.minecraft.class_3194;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TheBlockKeepsTicking
implements ModInitializer {
    public static final String MOD_ID = "the-block-keeps-ticking";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"the-block-keeps-ticking");
    public static final AttachmentType<Long> LAST_UPDATE_TIME = AttachmentRegistry.createPersistent((class_2960)class_2960.method_60655((String)"the-block-keeps-ticking", (String)"last_update_time"), (Codec)Codec.LONG);
    public static final AttachmentType<Long> LAST_REALTIME_UPDATE_MS = AttachmentRegistry.createPersistent((class_2960)class_2960.method_60655((String)"the-block-keeps-ticking", (String)"last_realtime_update_ms"), (Codec)Codec.LONG);

    public void onInitialize() {
        LOGGER.info("The Block Keeps Ticking is initializing!");
        ModConfig.HANDLER.load();
        WorldSimulator.Initialize();
        Timer.RegisterShutdownEvent();
        ServerChunkEvents.CHUNK_LEVEL_TYPE_CHANGE.register((world, chunk, oldType, newType) -> {
            long currentWorldTime = world.method_8510();
            long nowMs = System.currentTimeMillis();
            if (newType == class_3194.field_44856 && oldType != class_3194.field_44856) {
                long ticksToSimulate;
                if (ModConfig.getTimeMode() == ModConfig.TimeMode.REALTIME) {
                    long lastMs = (Long)chunk.getAttachedOrSet(LAST_REALTIME_UPDATE_MS, (Object)nowMs);
                    ticksToSimulate = Math.max(0L, (nowMs - lastMs) / 50L);
                } else {
                    long lastTickTime = (Long)chunk.getAttachedOrSet(LAST_UPDATE_TIME, (Object)currentWorldTime);
                    ticksToSimulate = currentWorldTime - lastTickTime;
                }
                Timer.INSTANCE.Schedule("chunk_simulation_" + chunk.method_12004().method_8324(), (server, chunkToSimulate) -> WorldSimulator.SimulateWorld(chunkToSimulate, ticksToSimulate), chunk);
            } else if (oldType == class_3194.field_44856 && newType != class_3194.field_44856) {
                chunk.setAttached(LAST_UPDATE_TIME, (Object)currentWorldTime);
                chunk.setAttached(LAST_REALTIME_UPDATE_MS, (Object)nowMs);
            }
        });
    }
}

