/*
 * Decompiled with CFR 0.152.
 */
package magicjinn.theblockkeepsticking.config;

import dev.isxander.yacl3.config.v2.api.ConfigClassHandler;
import dev.isxander.yacl3.config.v2.api.SerialEntry;
import dev.isxander.yacl3.config.v2.api.serializer.GsonConfigSerializerBuilder;
import java.util.LinkedHashMap;
import java.util.Map;
import magicjinn.theblockkeepsticking.simulator.WorldSimulator;
import magicjinn.theblockkeepsticking.util.TickingObject;
import net.fabricmc.loader.api.FabricLoader;

public final class ModConfig {
    public static final ConfigClassHandler<ModConfig> HANDLER = ConfigClassHandler.createBuilder(ModConfig.class).serializer(config -> GsonConfigSerializerBuilder.create((ConfigClassHandler)config).setPath(FabricLoader.getInstance().getConfigDir().resolve("the-block-keeps-ticking.json")).build()).build();
    @SerialEntry
    Map<String, Boolean> enabledByName = new LinkedHashMap<String, Boolean>();
    @SerialEntry
    int lazyTaxPercent = 0;
    @SerialEntry
    TimeMode timeMode = TimeMode.WORLD_TIME;
    @SerialEntry
    boolean debugLogging = false;

    public static ModConfig getInstance() {
        return (ModConfig)HANDLER.instance();
    }

    public static boolean isEnabled(String tickingObjectName) {
        Boolean enabled = ModConfig.getInstance().enabledByName.get(tickingObjectName);
        return enabled == null ? true : enabled;
    }

    public static long applyLazyTax(long ticksToSimulate) {
        if (ticksToSimulate <= 0L) {
            return 0L;
        }
        int p = ModConfig.getInstance().lazyTaxPercent;
        if (p == 0) {
            return ticksToSimulate;
        }
        double factor = 1.0 - (double)p / 100.0;
        long adjusted = (long)Math.floor((double)ticksToSimulate * factor);
        return Math.max(0L, adjusted);
    }

    public static TimeMode getTimeMode() {
        return ModConfig.getInstance().timeMode;
    }

    public static void setTimeMode(TimeMode mode) {
        ModConfig.getInstance().timeMode = mode;
        HANDLER.save();
    }

    public static int getLazyTaxPercent() {
        return ModConfig.getInstance().lazyTaxPercent;
    }

    public static void setLazyTaxPercent(int percent) {
        ModConfig.getInstance().lazyTaxPercent = percent;
        HANDLER.save();
    }

    public static Map<String, Boolean> getEnabledByName() {
        return ModConfig.getInstance().enabledByName;
    }

    public static boolean isDebugLogging() {
        return ModConfig.getInstance().debugLogging;
    }

    public static void setDebugLogging(boolean enabled) {
        ModConfig.getInstance().debugLogging = enabled;
        HANDLER.save();
    }

    public static void ensureDefaultsPresent() {
        for (TickingObject tickingObject : WorldSimulator.TickingObjectInstances) {
            ModConfig.getInstance().enabledByName.putIfAbsent(tickingObject.getName(), Boolean.TRUE);
        }
    }

    public static enum TimeMode {
        WORLD_TIME,
        REALTIME;


        public String toString() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> "World Time";
                case 1 -> "Real Time";
            };
        }
    }
}

