/*
 * Decompiled with CFR 0.152.
 */
package magicjinn.theblockkeepsticking.simulator;

import java.util.ArrayList;
import java.util.List;
import magicjinn.theblockkeepsticking.TheBlockKeepsTicking;
import magicjinn.theblockkeepsticking.blocks.TickingAbstractFurnaceBlockEntity;
import magicjinn.theblockkeepsticking.blocks.TickingBambooBlock;
import magicjinn.theblockkeepsticking.blocks.TickingBambooShootBlock;
import magicjinn.theblockkeepsticking.blocks.TickingBrewingStandBlockEntity;
import magicjinn.theblockkeepsticking.blocks.TickingCactusBlock;
import magicjinn.theblockkeepsticking.blocks.TickingCampfireBlockEntity;
import magicjinn.theblockkeepsticking.blocks.TickingCocoaBlock;
import magicjinn.theblockkeepsticking.blocks.TickingCropBlock;
import magicjinn.theblockkeepsticking.blocks.TickingDriedGhastBlock;
import magicjinn.theblockkeepsticking.blocks.TickingKelpBlock;
import magicjinn.theblockkeepsticking.blocks.TickingNetherWartBlock;
import magicjinn.theblockkeepsticking.blocks.TickingSaplingBlock;
import magicjinn.theblockkeepsticking.blocks.TickingSnifferEggBlock;
import magicjinn.theblockkeepsticking.blocks.TickingStemBlock;
import magicjinn.theblockkeepsticking.blocks.TickingSugarCaneBlock;
import magicjinn.theblockkeepsticking.config.ModConfig;
import magicjinn.theblockkeepsticking.entities.TickingPassiveEntity;
import magicjinn.theblockkeepsticking.util.TickingObject;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_2826;
import org.apache.commons.lang3.function.TriConsumer;

public class WorldSimulator {
    public static final ArrayList<TickingObject> TickingObjectInstances = new ArrayList();
    private static final ArrayList<TickingObject> TickingBlockInstances = new ArrayList();
    private static final ArrayList<TickingObject> TickingBlockEntityInstances = new ArrayList();
    private static final ArrayList<TickingObject> TickingEntityInstances = new ArrayList();

    public static void Initialize() {
        WorldSimulator.RegisterTickingBlock(TickingAbstractFurnaceBlockEntity.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingCampfireBlockEntity.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingBrewingStandBlockEntity.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingCropBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingStemBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingNetherWartBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingCocoaBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingSaplingBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingKelpBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingBambooBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingBambooShootBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingSugarCaneBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingCactusBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingPassiveEntity.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingDriedGhastBlock.INSTANCE);
        WorldSimulator.RegisterTickingBlock(TickingSnifferEggBlock.INSTANCE);
    }

    public static void RegisterTickingBlock(TickingObject tickingObject) {
        if (tickingObject == null) {
            TheBlockKeepsTicking.LOGGER.warn("Tried to register null TickingObject");
            return;
        }
        TickingObjectInstances.add(tickingObject);
        Class<?> type = tickingObject.getType();
        if (type == null) {
            TheBlockKeepsTicking.LOGGER.warn("TickingObject returned null type: " + tickingObject.getClass().getName());
            return;
        }
        if (class_2248.class.isAssignableFrom(type)) {
            TickingBlockInstances.add(tickingObject);
        } else if (class_2586.class.isAssignableFrom(type)) {
            TickingBlockEntityInstances.add(tickingObject);
        } else if (class_1297.class.isAssignableFrom(type)) {
            TickingEntityInstances.add(tickingObject);
        } else {
            TheBlockKeepsTicking.LOGGER.warn("Unsupported TickingObject type: " + type.getName());
            return;
        }
        TheBlockKeepsTicking.LOGGER.info("Registered TickingBlock: " + tickingObject.getName() + " by " + tickingObject.getModId());
    }

    public static void SimulateWorld(class_2818 chunk, long ticksToSimulate) {
        if (chunk == null) {
            TheBlockKeepsTicking.LOGGER.warn("Tried to simulate null chunk!");
            return;
        }
        class_1937 world = chunk.method_12200();
        long ticks = ModConfig.applyLazyTax(ticksToSimulate);
        if (ticks <= 0L) {
            return;
        }
        boolean doDebugLogging = ModConfig.isDebugLogging();
        try {
            WorldSimulator.forEachBlockInChunk(chunk, (TriConsumer<class_2248, class_2680, class_2338>)((TriConsumer)(block, state, pos) -> {
                for (TickingObject tickingBlock : TickingBlockInstances) {
                    if (!WorldSimulator.checkIfInstanceOf(tickingBlock, block).booleanValue()) continue;
                    if (!ModConfig.isEnabled(tickingBlock.getName())) {
                        return;
                    }
                    boolean result = tickingBlock.Simulate(block, ticks, world, (class_2680)state, (class_2338)pos);
                    if (result && doDebugLogging) {
                        TheBlockKeepsTicking.LOGGER.info("Simulating block {} for {} ticks", (Object)block.method_9518().toString(), (Object)ticks);
                    }
                    return;
                }
            }));
            block2: for (class_2586 blockEntity : chunk.method_12214().values()) {
                if (blockEntity == null) continue;
                for (TickingObject tickingBlockEntity : TickingBlockEntityInstances) {
                    boolean result;
                    if (!WorldSimulator.checkIfInstanceOf(tickingBlockEntity, blockEntity).booleanValue()) continue;
                    if (!ModConfig.isEnabled(tickingBlockEntity.getName()) || !(result = tickingBlockEntity.Simulate(blockEntity, ticks, world, blockEntity.method_11010(), blockEntity.method_11016())) || !doDebugLogging) continue block2;
                    TheBlockKeepsTicking.LOGGER.info("Simulating block entity {} for {} ticks", (Object)blockEntity.method_61177(), (Object)ticks);
                    continue block2;
                }
            }
            class_1923 chunkPos = chunk.method_12004();
            class_238 box = new class_238((double)chunkPos.method_8326(), (double)world.method_31607(), (double)chunkPos.method_8328(), (double)chunkPos.method_8327(), (double)world.method_31605(), (double)chunkPos.method_8329());
            List passiveEntities = world.method_8390(class_1296.class, box, PassiveEntity -> true);
            for (class_1296 passiveEntity : passiveEntities) {
                for (TickingObject tickingEntity : TickingEntityInstances) {
                    boolean result;
                    if (!WorldSimulator.checkIfInstanceOf(tickingEntity, passiveEntity).booleanValue() || !ModConfig.isEnabled(tickingEntity.getName()) || !(result = tickingEntity.Simulate(passiveEntity, ticks, world, null, null)) || !doDebugLogging) continue;
                    TheBlockKeepsTicking.LOGGER.info("Simulating entity {} for {} ticks", (Object)passiveEntity.method_5477(), (Object)ticks);
                }
            }
        }
        catch (Exception e) {
            TheBlockKeepsTicking.LOGGER.error("Error during world simulation: ", (Throwable)e);
        }
    }

    private static Boolean checkIfInstanceOf(TickingObject tickingBlock, Object block) {
        return tickingBlock.getType().isInstance(block);
    }

    public static void forEachBlockInChunk(class_2818 chunk, TriConsumer<class_2248, class_2680, class_2338> action) {
        class_1923 chunkPos = chunk.method_12004();
        int chunkStartX = chunkPos.method_8326();
        int chunkBottomY = chunk.method_31607();
        int chunkStartZ = chunkPos.method_8328();
        int sections = chunk.method_31605() >> 4;
        for (int sectionY = sections - 1; sectionY >= 0; --sectionY) {
            class_2826 section = chunk.method_12006()[sectionY];
            if (section == null || section.method_38292()) continue;
            for (int x = 0; x < 16; ++x) {
                for (int y = 15; y >= 0; --y) {
                    for (int z = 0; z < 16; ++z) {
                        class_2680 state = section.method_12254(x, y, z);
                        class_2338 blockPos = new class_2338(chunkStartX + x, (sectionY << 4) + chunkBottomY + y, chunkStartZ + z);
                        class_2248 block = state.method_26204();
                        action.accept((Object)block, (Object)state, (Object)blockPos);
                    }
                }
            }
        }
    }
}

