/*
 * Decompiled with CFR 0.152.
 */
package magicjinn.theblockkeepsticking.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.minecraft.class_2818;
import net.minecraft.server.MinecraftServer;

public class Timer
implements ServerTickEvents.EndTick {
    public static final Timer INSTANCE = new Timer();
    private final Map<String, TimerEntry> pendingActions = new ConcurrentHashMap<String, TimerEntry>();

    public void Schedule(String id, BiConsumer<MinecraftServer, class_2818> callback, class_2818 chunk) {
        this.Schedule(id, 20L, callback, chunk);
    }

    public void Schedule(String id, long ticksUntilAction, BiConsumer<MinecraftServer, class_2818> callback, class_2818 chunk) {
        this.pendingActions.put(id, new TimerEntry(ticksUntilAction, callback, chunk));
    }

    public void Cancel(String id) {
        this.pendingActions.remove(id);
    }

    public void onEndTick(MinecraftServer server) {
        this.pendingActions.entrySet().removeIf(entry -> {
            TimerEntry timerEntry = (TimerEntry)entry.getValue();
            if (timerEntry.tick()) {
                try {
                    timerEntry.execute(server);
                }
                catch (Exception e) {
                    System.err.println("Error executing timer callback: " + e.getMessage());
                }
                return true;
            }
            return false;
        });
    }

    public void clearAllPendingActions() {
        this.pendingActions.clear();
    }

    public static void RegisterShutdownEvent() {
        ServerTickEvents.END_SERVER_TICK.register((Object)INSTANCE);
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> INSTANCE.clearAllPendingActions());
    }

    private static class TimerEntry {
        private long ticksRemaining;
        private final BiConsumer<MinecraftServer, class_2818> callback;
        private final class_2818 chunk;

        public TimerEntry(long ticksRemaining, BiConsumer<MinecraftServer, class_2818> callback, class_2818 chunk) {
            this.ticksRemaining = ticksRemaining;
            this.callback = callback;
            this.chunk = chunk;
        }

        public boolean tick() {
            return --this.ticksRemaining <= 0L;
        }

        public void execute(MinecraftServer server) {
            this.callback.accept(server, this.chunk);
        }
    }
}

