package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.sugar.Local;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import net.minecraft.class_1799;
import net.minecraft.class_3803;

@Mixin(class_3803.class)
public class GrindstoneScreenHandlerMixin {
	@Inject(
		method = "grind",
		at = @At("RETURN")
	)
	private void includeElementInGrind(class_1799 item, CallbackInfoReturnable<class_1799> cir) {
		ElementalInfusionComponent.removeInfusion(item);
	}

	@ModifyExpressionValue(
		method = "getOutputStack",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/enchantment/EnchantmentHelper;hasEnchantments(Lnet/minecraft/item/ItemStack;)Z"
		)
	)
	private boolean checkForElementInResult(boolean original, @Local(ordinal = 2) class_1799 stack) {
		return original || ElementalInfusionComponent.hasInfusion(stack);
	}

	@ModifyReturnValue(
		method = "getOutputStack",
		at = @At(
			value = "RETURN",
			ordinal = 1
		)
	)
	private class_1799 checkForElementInStacks(class_1799 original, @Local(argsOnly = true, ordinal = 0) class_1799 firstInput, @Local(argsOnly = true, ordinal = 1) class_1799 secondInput) {
		return (class_1799.method_7984(firstInput, secondInput) || !(firstInput.method_7960() == secondInput.method_7960()))
			&& (firstInput.method_7947() + secondInput.method_7947() <= 64)
			? new class_1799(firstInput.method_7909(), firstInput.method_7947() + secondInput.method_7947())
			: original;
	}
}
