package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;

import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_9322;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext.Builder;
import io.github.xrickastley.sevenelements.element.InternalCooldownTag;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.factory.SevenElementsComponents;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import io.github.xrickastley.sevenelements.util.TextHelper;

// Prioritized since Frozen **MUST** disable using items.
@Mixin(value = class_1799.class, priority = Integer.MIN_VALUE)
public abstract class ItemStackMixin implements class_9322 {
	@Shadow
	public abstract class_1792 getItem();

	@WrapOperation(
		method = "use",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/item/Item;use(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/TypedActionResult;"
		)
	)
	private class_1271<class_1799> frozenPreventsItemUse(class_1792 instance, class_1937 world, class_1657 user, class_1268 hand, Operation<class_1271<class_1799>> original) {
		class_1799 handStack = user.method_5998(hand);

		return user.method_6059(SevenElementsStatusEffects.FROZEN)
			? class_1271.method_22431(handStack)
			: original.call(instance, world, user, hand);
	}

	@ModifyReturnValue(
		method = "getName",
		at = @At("RETURN")
	)
	private class_2561 modifyName(class_2561 original) {
		final @Nullable ElementalInfusionComponent component = this.method_57824(SevenElementsComponents.ELEMENTAL_INFUSION_COMPONENT);

		if (component == null || !component.hasElementalInfusion()) return original;

		final Element element = component.getElement();

		return class_2561.method_43473()
			.method_10852(original)
			.method_10852(TextHelper.noModifiers(TextHelper.color(" [" + element.getString() + "]", element.getDamageColor())));
	}

	@Inject(
		method = "getTooltip",
		at = @At(
			value = "INVOKE",
			target = "Ljava/util/List;add(Ljava/lang/Object;)Z",
			ordinal = 3
		)
	)
	private void addInfusionData(class_1792.class_9635 context, @Nullable class_1657 player, class_1836 _type, CallbackInfoReturnable<List<class_2561>> cir, @Local List<class_2561> texts) {
		final @Nullable ElementalInfusionComponent component = this.method_57824(SevenElementsComponents.ELEMENTAL_INFUSION_COMPONENT);

		if (component == null || !component.hasElementalInfusion()) return;

		final Builder builder = component.internalCooldown();

		texts.add(
			class_2561.method_43473()
				.method_10852(class_2561.method_43471("item.seven-elements.components.infusion.infusion").method_27692(class_124.field_1068))
				.method_10852(ElementalApplication.Builder.getText(component.elementalInfusion()))
		);



		@Nullable InternalCooldownTag tag = ClassInstanceUtil.mapOrNull(builder, Builder::getTag);

		final class_2561 tagText = tag != null
			? tag.getText(class_124.field_1063)
			: class_2561.method_43470("none").method_27692(class_124.field_1061);

		texts.add(
			class_2561.method_43473()
				.method_10852(class_2561.method_43471("item.seven-elements.components.infusion.tag").method_27692(class_124.field_1068))
				.method_10852(tagText)
		);



		final InternalCooldownType type = JavaScriptUtil.nullishCoalesing(
			ClassInstanceUtil.mapOrNull(builder, Builder::getType),
			InternalCooldownType.DEFAULT
		);

		texts.add(
			class_2561.method_43473()
				.method_10852(class_2561.method_43471("item.seven-elements.components.infusion.type").method_27692(class_124.field_1068))
				.method_10852(type.getText(true).method_27692(class_124.field_1063))
		);
	}
}
