package io.github.xrickastley.sevenelements.util;

import com.google.common.collect.Sets;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1657;
import net.minecraft.class_1927;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_5134;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.mixin.ExplosionAccessor;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;

/**
 * A class for explosions that don't damage entities.
 */
public class NonEntityDamagingExplosion extends class_1927 {
	private class_1937 world;
	private double x;
	private double y;
	private double z;
	private @Nullable class_1297 entity;
	private float power;
	private class_5362 behavior;
	private ObjectArrayList<class_2338> affectedBlocks;
	private Map<class_1657, class_243> affectedPlayers;
	private final List<class_1297> affectedEntities = new ArrayList<>();

	public NonEntityDamagingExplosion(final class_1937 world, final @Nullable class_1297 entity, final double x, final double y, final double z, final float power, final List<class_2338> affectedBlocks) {
		super(world, entity, x, y, z, power, false, class_1927.class_4179.field_40879, affectedBlocks);

		supplyFromAccessor();
	}

	public NonEntityDamagingExplosion(final class_1937 world, final @Nullable class_1297 entity, final double x, final double y, final double z, final float power, final boolean createFire, final class_1927.class_4179 destructionType, final List<class_2338> affectedBlocks) {
		super(world, entity, x, y, z, power, createFire, destructionType, affectedBlocks);

		supplyFromAccessor();
	}

	public NonEntityDamagingExplosion(final class_1937 world, final @Nullable class_1297 entity, final double x, final double y, final double z, final float power, final boolean createFire, final class_1927.class_4179 destructionType) {
		super(world, entity, x, y, z, power, createFire, destructionType);

		supplyFromAccessor();
	}

	public NonEntityDamagingExplosion(final class_1937 world, final @Nullable class_1297 entity, final @Nullable class_5362 behavior, final double x, final double y, final double z, final float power, final boolean createFire, final class_1927.class_4179 destructionType) {
		super(world, entity, null, behavior, x, y, z, power, createFire, destructionType, class_2398.field_11236, class_2398.field_11221, class_3417.field_15152);

		supplyFromAccessor();
	}

	/**
	 * Another version of {@link class_1927#method_8348}, but pushes
	 * entities (applies velocity) instead of damaging them.
	 */
	public void collectBlocksAndPushEntities() {
		this.world.method_43275(this.entity, class_5712.field_28178, new class_243(this.x, this.y, this.z));
		final Set<class_2338> set = Sets.newHashSet();

		for (int j = 0; j < 16; ++j) {
			for (int k = 0; k < 16; ++k) {
				for (int l = 0; l < 16; ++l) {
					if (j == 0 || j == 15 || k == 0 || k == 15 || l == 0 || l == 15) {
						double d = j / 15.0f * 2.0f - 1.0f;
						double e = k / 15.0f * 2.0f - 1.0f;
						double f = l / 15.0f * 2.0f - 1.0f;
						final double g = Math.sqrt(d * d + e * e + f * f);

						d /= g;
						e /= g;
						f /= g;

						float h = this.power * (0.7f + this.world.field_9229.method_43057() * 0.6f);
						double m = this.x;
						double n = this.y;
						double o = this.z;

						while (h > 0.0f) {
							final class_2338 blockPos = class_2338.method_49637(m, n, o);
							final class_2680 blockState = this.world.method_8320(blockPos);
							final class_3610 fluidState = this.world.method_8316(blockPos);

							if (!this.world.method_24794(blockPos)) break;

							final Optional<Float> optional = this.behavior.method_29555(this, this.world, blockPos, blockState, fluidState);

							if (optional.isPresent()) h -= (optional.get() + 0.3f) * 0.3f;

							if (h > 0.0f && this.behavior.method_29554(this, this.world, blockPos, blockState, h)) {
								set.add(blockPos);
							}
							m += d * 0.30000001192092896;
							n += e * 0.30000001192092896;
							o += f * 0.30000001192092896;
							h -= 0.22500001f;
						}
					}
				}
			}
		}

		this.affectedBlocks.addAll(set);

		final float q = this.power * 2.0f;
		int k = class_3532.method_15357(this.x - q - 1.0);
		int l = class_3532.method_15357(this.x + q + 1.0);
		final int r = class_3532.method_15357(this.y - q - 1.0);
		final int s = class_3532.method_15357(this.y + q + 1.0);
		final int t = class_3532.method_15357(this.z - q - 1.0);
		final int u = class_3532.method_15357(this.z + q + 1.0);

		final List<class_1297> list = this.world.method_8335(this.entity, new class_238(k, r, t, l, s, u));
		final class_243 vec3d = new class_243(this.x, this.y, this.z);

		for (final class_1297 entity : list) {
			if (entity.method_5659(this)) continue;

			final double v = Math.sqrt(entity.method_5707(vec3d)) / q;

			if (v > 1.0) continue;

			double w = entity.method_23317() - this.x;
			double x = ((entity instanceof class_1541) ? entity.method_23318() : entity.method_23320()) - this.y;
			double y = entity.method_23321() - this.z;
			final double z = Math.sqrt(w * w + x * x + y * y);

			if (z == 0.0) continue;

			w /= z;
			x /= z;
			y /= z;

			final double aa = (1.0 - v) * method_17752(vec3d, entity) * this.behavior.method_57007(entity);
			final double ab = entity instanceof class_1309 livingEntity
				? aa * (1.0 - livingEntity.method_45325(class_5134.field_51580))
				: aa;

			this.affectedEntities.add(entity);

			w *= ab;
			x *= ab;
			y *= ab;

			final class_243 vec3d2 = new class_243(w, x, y);

			entity.method_18799(entity.method_18798().method_1019(vec3d2));

			if (!(entity instanceof final class_1657 playerEntity)) continue;

			if (playerEntity.method_7325() || (playerEntity.method_7337() && playerEntity.method_31549().field_7479)) {
				continue;
			}

			this.affectedPlayers.put(playerEntity, vec3d2);
			entity.method_56918(this.entity);
		}
	}

	public List<class_1297> getAffectedEntities() {
		return this.affectedEntities;
	}

	private void supplyFromAccessor() {
		final ExplosionAccessor accessor = (ExplosionAccessor) this;

		this.world = accessor.getWorld();
		this.x = accessor.getX();
		this.y = accessor.getY();
		this.z = accessor.getZ();
		this.entity = accessor.getEntity();
		this.power = accessor.getPower();
		this.behavior = accessor.getBehavior();
		this.affectedBlocks = accessor.getAffectedBlocks();
		this.affectedPlayers = accessor.getAffectedPlayers();
	}
}
