/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element;

import io.github.xrickastley.sevenelements.element.InternalCooldownHolder;
import io.github.xrickastley.sevenelements.element.InternalCooldownTag;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;

public final class InternalCooldown {
    private final InternalCooldownHolder holder;
    private final InternalCooldownType type;
    private final InternalCooldownTag tag;
    private int cooldown = 0;
    private int totalHits = 0;

    InternalCooldown(InternalCooldownHolder holder, InternalCooldownTag tag, InternalCooldownType type) {
        this.holder = holder;
        this.type = type;
        this.tag = tag;
    }

    public static String getIdentifier(InternalCooldownTag tag, InternalCooldownType type) {
        return tag.getTag() + type.getId().toString();
    }

    public static String getIdentifier(String tag, InternalCooldownType type) {
        return tag + type.getId().toString();
    }

    static InternalCooldown none(InternalCooldownHolder holder) {
        return new InternalCooldown(holder, InternalCooldownTag.NONE, InternalCooldownType.NONE);
    }

    public boolean isInInternalCooldown() {
        return this.tag.getTag() != null && this.holder.getOwner().field_6012 >= this.cooldown || this.totalHits > this.type.getGaugeSequence();
    }

    public boolean handleInternalCooldown() {
        if (this.tag.getTag() == null) {
            return true;
        }
        if (this.holder.getOwner().field_6012 >= this.cooldown) {
            this.cooldown = this.holder.getOwner().field_6012 + this.type.getResetInterval();
            this.totalHits = 1;
            return true;
        }
        if (this.totalHits >= this.type.getGaugeSequence()) {
            this.totalHits = 1;
            return true;
        }
        ++this.totalHits;
        return false;
    }
}

