/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.networking;

import io.github.xrickastley.sevenelements.SevenElementsClient;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.entity.CrystallizeShardEntity;
import io.github.xrickastley.sevenelements.entity.DendroCoreEntity;
import io.github.xrickastley.sevenelements.gui.screen.ingame.ElementalInfusionScreen;
import io.github.xrickastley.sevenelements.networking.FinishElementalInfusionS2CPayload;
import io.github.xrickastley.sevenelements.networking.PayloadHandler;
import io.github.xrickastley.sevenelements.networking.ShowElementalDamageS2CPayload;
import io.github.xrickastley.sevenelements.networking.ShowElementalReactionS2CPayload;
import io.github.xrickastley.sevenelements.networking.SyncDendroCoreAgeS2CPayload;
import io.github.xrickastley.sevenelements.renderer.WorldTextRenderer;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.ClientConfig;
import io.github.xrickastley.sevenelements.util.Color;
import io.github.xrickastley.sevenelements.util.Colors;
import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_634;
import net.minecraft.class_746;
import net.minecraft.class_8710;

@Environment(value=EnvType.CLIENT)
public class SevenElementsPacketsS2C {
    private static final List<PayloadHandler<? extends class_8710>> HANDLERS = new ArrayList<PayloadHandler<? extends class_8710>>();
    private static boolean registered = false;

    public static void register() {
        ClientPlayConnectionEvents.INIT.register(SevenElementsPacketsS2C::onPlayInit);
    }

    public static void registerHandler(PayloadHandler<? extends class_8710> handler) {
        if (registered) {
            throw new IllegalStateException("All ClientPlayConnectionEvents.INIT handlers have already been registered!");
        }
        HANDLERS.add(handler);
    }

    private static void registerHandlers() {
        registered = true;
        for (PayloadHandler<? extends class_8710> handler : HANDLERS) {
            ClientPlayNetworking.registerGlobalReceiver(handler.getPayloadId(), (ClientPlayNetworking.PlayPayloadHandler)((ClientPlayNetworking.PlayPayloadHandler)ClassInstanceUtil.cast(handler)));
        }
    }

    private static void onPlayInit(class_634 handler, class_310 client) {
        ClientPlayNetworking.registerGlobalReceiver(ShowElementalReactionS2CPayload.ID, SevenElementsPacketsS2C::onElementalReactionShow);
        ClientPlayNetworking.registerGlobalReceiver(ShowElementalDamageS2CPayload.ID, SevenElementsPacketsS2C::onElementalDamageShow);
        ClientPlayNetworking.registerGlobalReceiver(SyncDendroCoreAgeS2CPayload.ID, SevenElementsPacketsS2C::onSyncDendroCoreAge);
        ClientPlayNetworking.registerGlobalReceiver(CrystallizeShardEntity.SyncCrystallizeShardTypeS2CPayload.ID, SevenElementsPacketsS2C::onSyncCrystallizeShardElement);
        ClientPlayNetworking.registerGlobalReceiver(FinishElementalInfusionS2CPayload.ID, SevenElementsPacketsS2C::onFinishElementalInfusion);
        SevenElementsPacketsS2C.registerHandlers();
    }

    private static void onElementalReactionShow(ShowElementalReactionS2CPayload payload, ClientPlayNetworking.Context context) {
        class_243 pos = payload.pos();
        ElementalReaction reaction = payload.reaction();
        if (reaction == null || reaction.getText() == null) {
            return;
        }
        SevenElementsClient.WORLD_TEXT_RENDERER.addEntry(new WorldTextRenderer.ReactionText(pos.field_1352, pos.field_1351, pos.field_1350, Colors.PHYSICAL, reaction.getText()));
    }

    private static void onElementalDamageShow(ShowElementalDamageS2CPayload payload, ClientPlayNetworking.Context context) {
        float amount;
        ClientConfig config = ClientConfig.get();
        if (!config.rendering.text.showDamageText) {
            return;
        }
        class_243 pos = payload.pos();
        Color color = payload.element() != null && payload.element().hasDamageColor() ? payload.element().getDamageColor() : Colors.PHYSICAL;
        float f = amount = config.developer.genshinDamageLim ? Math.min(payload.amount(), 2.0E7f) : payload.amount();
        if (amount == Float.MAX_VALUE) {
            return;
        }
        SevenElementsClient.WORLD_TEXT_RENDERER.addEntry(new WorldTextRenderer.DamageText(pos.field_1352, pos.field_1351, pos.field_1350, color, amount, payload.crit() ? config.rendering.text.critDMGScale : config.rendering.text.normalDMGScale));
    }

    private static void onSyncDendroCoreAge(SyncDendroCoreAgeS2CPayload payload, ClientPlayNetworking.Context context) {
        class_1937 world = class_310.method_1551().field_1724.method_37908();
        class_1297 entity = world.method_8469(payload.entityId());
        if (!(entity instanceof DendroCoreEntity)) {
            return;
        }
        DendroCoreEntity dendroCore = (DendroCoreEntity)entity;
        dendroCore.field_6012 = payload.age();
    }

    private static void onSyncCrystallizeShardElement(CrystallizeShardEntity.SyncCrystallizeShardTypeS2CPayload payload, ClientPlayNetworking.Context context) {
        class_1937 world = class_310.method_1551().field_1724.method_37908();
        class_1297 entity = world.method_8469(payload.entityId());
        if (!(entity instanceof CrystallizeShardEntity)) {
            return;
        }
        CrystallizeShardEntity crystallizeShard = (CrystallizeShardEntity)entity;
        crystallizeShard.syncFromPacket(payload);
    }

    private static void onFinishElementalInfusion(FinishElementalInfusionS2CPayload payload, ClientPlayNetworking.Context context) {
        class_746 playerEntity = context.player();
        class_1703 screenHandler = playerEntity.field_7512;
        class_437 currentScreen = context.client().field_1755;
        if (screenHandler != null && screenHandler.field_7763 == payload.syncId() && currentScreen instanceof ElementalInfusionScreen) {
            ElementalInfusionScreen screen = (ElementalInfusionScreen)currentScreen;
            screen.finishElementalInfusion(payload);
        }
    }
}

