/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.util;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.function.Function;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_243;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_9801;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

@Environment(value=EnvType.CLIENT)
public final class SphereRenderer {
    private SphereRenderer() {
    }

    public static void render(class_4587 matrices, class_243 origin, float radius, int latSteps, int lonSteps, int color) {
        SphereRenderer.render(matrices, origin, radius, latSteps, lonSteps, pos -> color);
    }

    public static void render(class_4587 matrices, class_243 origin, float radius, int latSteps, int lonSteps, Function<class_243, Integer> colorFunc) {
        if (latSteps < 2) {
            latSteps = 2;
        }
        if (lonSteps < 3) {
            lonSteps = 3;
        }
        matrices.method_22903();
        matrices.method_22904(origin.field_1352, origin.field_1351, origin.field_1350);
        Matrix4f modelMat = matrices.method_23760().method_23761();
        Matrix3f normalMat = matrices.method_23760().method_23762();
        class_287 buf = class_289.method_1348().method_60827(class_293.class_5596.field_27379, class_290.field_1576);
        for (int lat = 0; lat < latSteps; ++lat) {
            double theta1 = Math.PI * (double)lat / (double)latSteps;
            double theta2 = Math.PI * (double)(lat + 1) / (double)latSteps;
            for (int lon = 0; lon < lonSteps; ++lon) {
                double phi1 = Math.PI * 2 * (double)lon / (double)lonSteps;
                double phi2 = Math.PI * 2 * (double)(lon + 1) / (double)lonSteps;
                class_243 v00 = SphereRenderer.spherical(radius, theta1, phi1);
                class_243 v01 = SphereRenderer.spherical(radius, theta1, phi2);
                class_243 v10 = SphereRenderer.spherical(radius, theta2, phi1);
                class_243 v11 = SphereRenderer.spherical(radius, theta2, phi2);
                SphereRenderer.vertex(buf, modelMat, normalMat, v10, colorFunc.apply(SphereRenderer.relativeClamp(v10, radius)));
                SphereRenderer.vertex(buf, modelMat, normalMat, v00, colorFunc.apply(SphereRenderer.relativeClamp(v00, radius)));
                SphereRenderer.vertex(buf, modelMat, normalMat, v11, colorFunc.apply(SphereRenderer.relativeClamp(v11, radius)));
                SphereRenderer.vertex(buf, modelMat, normalMat, v00, colorFunc.apply(SphereRenderer.relativeClamp(v00, radius)));
                SphereRenderer.vertex(buf, modelMat, normalMat, v11, colorFunc.apply(SphereRenderer.relativeClamp(v11, radius)));
                SphereRenderer.vertex(buf, modelMat, normalMat, v01, colorFunc.apply(SphereRenderer.relativeClamp(v01, radius)));
            }
        }
        RenderSystem.setShader(class_757::method_34540);
        class_286.method_43433((class_9801)buf.method_60800());
        matrices.method_22909();
    }

    private static class_243 spherical(double r, double theta, double phi) {
        double x = r * Math.sin(theta) * Math.cos(phi);
        double y = r * Math.cos(theta);
        double z = r * Math.sin(theta) * Math.sin(phi);
        return new class_243(x, y, z);
    }

    private static void vertex(class_287 buffer, Matrix4f projMat, Matrix3f normalMat, class_243 pos, int color) {
        buffer.method_22918(projMat, (float)pos.field_1352, (float)pos.field_1351, (float)pos.field_1350).method_39415(color);
    }

    private static class_243 relativeClamp(class_243 pos, float radius) {
        class_243 relPos = pos.method_1021((double)(1.0f / radius));
        return new class_243(class_3532.method_15350((double)relPos.field_1352, (double)-1.0, (double)1.0), class_3532.method_15350((double)relPos.field_1351, (double)-1.0, (double)1.0), class_3532.method_15350((double)relPos.field_1350, (double)-1.0, (double)1.0));
    }
}

