package io.github.xrickastley.sevenelements.element.reaction;

import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypes;
import net.minecraft.class_1293;
import net.minecraft.class_1309;

public abstract sealed class AbstractSuperconductElementalReaction
	extends ElementalReaction
	permits SuperconductElementalReaction, FrozenSuperconductElementalReaction
{
	AbstractSuperconductElementalReaction(Settings settings) {
		super(settings);
	}

	@Override
	protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
		for (final class_1309 target  : ElementalReaction.getEntitiesInAoE(entity, 3, t -> t != origin)) {
			final float damage = ElementalReaction.getReactionDamage(entity, 1.5);
			final ElementalDamageSource source = new ElementalDamageSource(
				entity
					.method_48923()
					.method_48796(SevenElementsDamageTypes.SUPERCONDUCT, origin),
				ElementalApplications.gaugeUnits(target, Element.CRYO, 0),
				InternalCooldownContext.ofNone(origin)
			).shouldApplyDMGBonus(false);

			target.method_5643(source, damage);
			target.method_37222(new class_1293(SevenElementsStatusEffects.SUPERCONDUCT, 240, 0, false, true), origin);
		}
	}
}
