package io.github.xrickastley.sevenelements.mixin;

import java.util.Optional;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1676;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_3545;
import net.minecraft.class_8046;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.interfaces.InfusableProjectile;
import io.github.xrickastley.sevenelements.util.ImmutablePair;

@Mixin(class_1676.class)
public abstract class ProjectileEntityMixin
	extends class_1297
	implements class_8046, InfusableProjectile
{
	@Unique
	private class_3545<ElementalApplication.Builder, InternalCooldownContext.Builder> sevenelements$infusionComponent;

   	public ProjectileEntityMixin(class_1299<? extends class_1676> entityType, class_1937 world) {
   		super(entityType, world);

		throw new AssertionError();
	}

	@Unique
	@Override
	public void sevenelements$setOriginStack(@Nullable class_1799 originStack) {
		if (originStack == null) return;

		final ElementalInfusionComponent component = ElementalInfusionComponent.get(originStack);

		this.sevenelements$infusionComponent = new ImmutablePair<>(
			component.elementalInfusion(),
			component.internalCooldown()
		);
	}

	@Unique
	@Override
	public Optional<ElementalDamageSource> sevenelements$attemptInfusion(class_1282 source, class_1297 _target) {
		return this.sevenelements$infusionComponent == null || this.sevenelements$infusionComponent.method_15442() == null || this.sevenelements$infusionComponent.method_15441() == null
			? Optional.empty()
			: _target instanceof final class_1309 target && source.method_5529() instanceof final class_1309 attacker
				? Optional.of(
					new ElementalDamageSource(
						source,
						this.sevenelements$infusionComponent.method_15442().build(target),
						this.sevenelements$infusionComponent.method_15441().build(attacker)
					)
				)
				: null;
	}

	@Inject(
		method = "writeCustomDataToNbt",
		at = @At("TAIL")
	)
	public void writeInfusionToNbt(class_2487 nbt, CallbackInfo ci) {
		if (this.sevenelements$infusionComponent == null || this.sevenelements$infusionComponent.method_15442() == null || this.sevenelements$infusionComponent.method_15441() == null) return;

		final class_2487 componentNbt = new class_2487();

		componentNbt.method_10566(
			"elemental_infusion",
			ElementalApplication.Builder.CODEC
				.encodeStart(class_2509.field_11560, this.sevenelements$infusionComponent.method_15442())
				.resultOrPartial(SevenElements.sublogger()::error)
				.orElseThrow()
		);

		componentNbt.method_10566(
			"internal_cooldown",
			InternalCooldownContext.Builder.CODEC
				.encodeStart(class_2509.field_11560, this.sevenelements$infusionComponent.method_15441())
				.resultOrPartial(SevenElements.sublogger()::error)
				.orElseThrow()
		);

		nbt.method_10566("seven-elements:elemental_infusion", componentNbt);
	}

	@Inject(
		method = "readCustomDataFromNbt",
		at = @At("TAIL")
	)
	public void readInfusionFromNbt(class_2487 nbt, CallbackInfo ci) {
		if (!nbt.method_10545("seven-elements:elemental_infusion")) return;

		final class_2487 componentNbt = (class_2487) nbt.method_10580("seven-elements:elemental_infusion");

		this.sevenelements$infusionComponent = new ImmutablePair<ElementalApplication.Builder,InternalCooldownContext.Builder>(
			ElementalApplication.Builder.CODEC
				.parse(class_2509.field_11560, componentNbt.method_10580("elemental_infusion"))
				.resultOrPartial(SevenElements.sublogger()::error)
				.orElseThrow(),
			InternalCooldownContext.Builder.CODEC
				.parse(class_2509.field_11560, componentNbt.method_10580("internal_cooldown"))
				.resultOrPartial(SevenElements.sublogger()::error)
				.orElseThrow()
		);
	}
}
