package io.github.xrickastley.sevenelements.mixin;

import com.mojang.serialization.Decoder;

import java.util.Map;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6903.class_7863;
import net.minecraft.class_7655;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.registry.dynamic.SevenElementsRegistryLoader;

@Mixin(class_7655.class)
public class RegistryLoaderMixin {
	@Inject(
		method = "load(Lnet/minecraft/registry/RegistryOps$RegistryInfoGetter;Lnet/minecraft/resource/ResourceManager;Lnet/minecraft/registry/RegistryKey;Lnet/minecraft/registry/MutableRegistry;Lcom/mojang/serialization/Decoder;Ljava/util/Map;)V",
		at = @At("HEAD"),
		cancellable = true
	)
	private static <E> void doSevenElementsLoadFromResource(
		class_7863 registryInfoGetter,
		class_3300 resourceManager,
		class_5321<? extends class_2378<E>> registryRef,
		class_2385<E> newRegistry,
		Decoder<E> decoder,
		Map<class_5321<?>, Exception> exceptions,
		CallbackInfo ci
	) {
		if (!SevenElementsRegistryLoader.isDynamicRegistry(newRegistry)) return;
		SevenElementsRegistryLoader.load(registryInfoGetter, resourceManager, registryRef, newRegistry, decoder, exceptions);
		ci.cancel();
	}
}
