package io.github.xrickastley.sevenelements.mixin.client;

import com.llamalad7.mixinextras.sugar.Local;

import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.util.Array;
import io.github.xrickastley.sevenelements.util.CircleRenderer;
import io.github.xrickastley.sevenelements.util.Functions;

@Mixin(class_329.class)
public class InGameHudMixin {
	@Shadow
	@Final
	private class_310 client;

	@Shadow
	@Final
	private static class_2960 POWDER_SNOW_OUTLINE;

	@Shadow
	private void renderOverlay(class_332 context, class_2960 texture, float opacity) {
		throw new AssertionError();
	}

	@Inject(
		method = "renderStatusBars",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/util/profiler/Profiler;swap(Ljava/lang/String;)V",
			shift = At.Shift.BEFORE,
			ordinal = 0
		)
	)
	private void renderAppliedElements(class_332 context, CallbackInfo ci, @Local class_1657 player, @Local(ordinal = 3) int x, @Local(ordinal = 9) int y) {
		this.client.method_16011().method_15405("origins-genshin:elements");

		int offset = 0;

		if (player.method_6096() > 0) offset += 1;

		y -= (10 * (offset));

		final ElementComponent component = ElementComponent.KEY.get(player);

		final double scaleFactor = class_310.method_1551().method_22683().method_4495();
		final Set<class_2960> existing = new HashSet<>();
		final Array<class_2960> appliedElements = component
			.getAppliedElements()
			.map(Functions.compose(ElementalApplication::getElement, Element::getTexture))
			.filter(existing::add);

		if (component.getCrystallizeShield() != null && component.getCrystallizeShield().method_15441() > 0)
			appliedElements.add(SevenElements.identifier("textures/status_effect/defense.png"));

		for (int i = 0; i < appliedElements.length(); i++) {
			final class_2960 texture = appliedElements.get(i);
			final int x1 = x + (i * 10);
			final CircleRenderer circleRenderer = new CircleRenderer((x1 + 4.5) * scaleFactor, (y + 4.5) * scaleFactor, 0);

			circleRenderer
				.add(4.5 * scaleFactor, 1, 0x7F646464)
				.draw(context.method_51448().method_23760().method_23761());

			context.method_25293(texture, x1, y, 9, 9, 0, 0, 9, 9, 9, 9);
		}
	}

	@Inject(
		method = "render(Lnet/minecraft/client/gui/DrawContext;F)V",
		at = @At(
			value = "INVOKE_ASSIGN",
			target = "Lnet/minecraft/client/gui/hud/InGameHud;getTextRenderer()Lnet/minecraft/client/font/TextRenderer;",
			shift = At.Shift.AFTER
		)
	)
	private void renderFrozenOverlay(class_332 context, float tickDelta, CallbackInfo ci) {
		if (client.field_1724 != null && client.field_1724.method_6059(SevenElementsStatusEffects.FROZEN))
			this.renderOverlay(context, POWDER_SNOW_OUTLINE, 1.0F);
	}
}
