package io.github.xrickastley.sevenelements.screen;

import java.util.List;

import io.github.xrickastley.sevenelements.advancement.criterion.SevenElementsCriteria;
import io.github.xrickastley.sevenelements.block.SevenElementsBlocks;
import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication.Type;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownTag;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.networking.FinishElementalInfusionS2CPayload;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;

import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1731;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3222;
import net.minecraft.class_3914;
import net.minecraft.class_5819;

public final class ElementalInfusionScreenHandler extends class_1703 {
	private static final List<Element> ELEMENTS = List.of(Element.PYRO, Element.HYDRO, Element.ANEMO, Element.ELECTRO, Element.DENDRO, Element.CRYO, Element.GEO);
	private static final List<Double> GAUGE_UNITS = List.of(1.0, 1.5, 2.0);
	private static final int REQUIRED_LEVEL = 10;

	private final class_3914 context;
	private final class_1731 output = new class_1731();
	private final class_5819 RANDOM = class_5819.method_43047();

	public ElementalInfusionScreenHandler(int syncId, class_1661 playerInventory) {
		this(syncId, playerInventory, class_3914.field_17304);
	}

	public ElementalInfusionScreenHandler(int syncId, class_1661 playerInventory, class_3914 context) {
		super(SevenElementsScreenHandlers.ELEMENTAL_INFUSION_SCREEN_HANDLER, syncId);

		this.context = context;

		this.method_7621(new LockableSlot(output, 0, 80, 60));

		int i;
		int j;

		for (i = 0; i < 3; ++i)
			for (j = 0; j < 9; ++j)
				this.method_7621(new class_1735(playerInventory, j + i * 9 + 9, 8 + j * 18, 164 + i * 18));

		for (i = 0; i < 9; ++i)
			this.method_7621(new class_1735(playerInventory, i, 8 + i * 18, 222));
	}

	@Override
	public class_1799 method_7601(class_1657 player, int slotId) {
		final class_1735 slot = this.field_7761.get(slotId);

		if (slot == null || !slot.method_7681()) return class_1799.field_8037;

		class_1799 stack = slot.method_7677();

		if (slotId == 0) {
			final class_1799 resultStack = slot.method_7677();
			stack = resultStack.method_7972();

			if (!this.method_7616(resultStack, 1, 37, false))
				return class_1799.field_8037;

			slot.method_7670(resultStack, stack);
		} else {
			if (!this.method_7616(stack, 0, 1, false))
				return class_1799.field_8037;
		}

		return stack;
	}

	@Override
	public boolean method_7597(class_1657 player) {
		return class_1703.method_17695(context, player, SevenElementsBlocks.INFUSION_TABLE);
	}

	public boolean canInfuse(class_1657 player) {
		return (player.field_7520 >= REQUIRED_LEVEL || player.method_7337()) && this.getResultSlot().method_7681();
	}

	public boolean infuse(class_1657 player) {
		if (!this.canInfuse(player) || !(player instanceof final class_3222 serverPlayer)) return false;

		final class_1735 slot = this.field_7761.get(0);

		if (slot == null || !slot.method_7681()) return false;

		final class_1799 stack = slot.method_7677();
		final Element element = ELEMENTS.get(RANDOM.method_43048(ELEMENTS.size()));

		ElementalInfusionComponent.applyInfusion(
			stack,
			ElementalApplications.builder()
				.setType(Type.GAUGE_UNIT)
				.setElement(element)
				.setGaugeUnits(GAUGE_UNITS.get(RANDOM.method_43048(GAUGE_UNITS.size()))),
			InternalCooldownContext.builder()
				.setTag(InternalCooldownTag.of("seven-elements:elemental_infusion"))
				.setType(InternalCooldownType.DEFAULT)
		);

		if (!player.method_7337()) serverPlayer.method_14252(serverPlayer.field_7520 - REQUIRED_LEVEL);

		slot.method_53512(stack);
		slot.method_7668();

		ServerPlayNetworking.send(serverPlayer, new FinishElementalInfusionS2CPayload(this));
		SevenElementsCriteria.ELEMENTAL_INFUSION.trigger(serverPlayer, stack, element);

		return true;
	}

	public LockableSlot getResultSlot() {
		// Should always be not null, if null, something wrong happened.
		return ClassInstanceUtil.castOrNull(this.method_7611(0), LockableSlot.class);
	}

	@Override
	public boolean method_7604(class_1657 player, int id) {
		if (!this.canInfuse(player)) return false;

		return this.infuse(player);
	}

	@Override
	public void method_7595(class_1657 player) {
		this.method_7607(player, this.output);
	}
}
