package io.github.xrickastley.sevenelements.element.reaction;

import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.registry.SevenElementsDamageTypes;
import net.minecraft.class_1309;
import net.minecraft.class_3218;

/*
 * DEV NOTE: No concept of "Poise" exists within Seven Elements, therefore the implementation of
 * Shatter has been modified slightly.
 *
 * When the target takes **any** Geo DMG (considering ICD) or when they are hit with a "Heavy Weapon",
 * Shatter is triggered and the Frozen Aura is removed.
 */
public abstract sealed class AbstractShatterElementalReaction
	extends ElementalReaction
	permits GeoShatterElementalReaction, HeavyShatterElementalReaction
{
	AbstractShatterElementalReaction(Settings settings) {
		super(settings);
	}

	@Override
	public boolean trigger(class_1309 entity, @Nullable class_1309 origin) {
		if (!isTriggerable(entity)) return false;

		final ElementComponent component = ElementComponent.KEY.get(entity);
		final ElementalApplication auraElement = component.getElementalApplication(this.auraElement.method_15442());
		final ElementalApplication triggeringElement = component.getElementalApplication(this.triggeringElement.method_15442());

		final double reducedGauge = auraElement.reduceGauge(Double.MAX_VALUE);

		this.onTrigger(entity, auraElement, triggeringElement, reducedGauge, origin);

		return true;
	}

	@Override
	protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {
		if (!(entity.method_37908() instanceof final class_3218 world)) return;

		final float damage = ElementalReaction.getReactionDamage(entity, 3.0);
		final ElementalDamageSource source = new ElementalDamageSource(
			entity
				.method_48923()
				.method_48796(SevenElementsDamageTypes.SHATTER, origin),
			ElementalApplications.gaugeUnits(entity, Element.PHYSICAL, 0.0, false),
			InternalCooldownContext.ofNone(entity)
		).shouldApplyDMGBonus(false).shouldInfuse(false);

		entity.method_64397(world, source, damage);
		entity.method_6016(SevenElementsStatusEffects.FROZEN);
	}
}
