package io.github.xrickastley.sevenelements.entity;

import java.util.Comparator;
import java.util.List;
import java.util.UUID;

import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.SevenElements;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.factory.SevenElementsSoundEvents;
import io.github.xrickastley.sevenelements.registry.SevenElementsEntityTypeTags;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import io.github.xrickastley.sevenelements.util.MathHelper2;

import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4844;
import net.minecraft.class_7094;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

// Should technically extend Entity, but extends LivingEntity instead to NOT deal with more Networking and Spawn Packets.
public final class CrystallizeShardEntity extends SevenElementsEntity {
	public final class_7094 idleAnimationState = new class_7094();
	private @Nullable Element element;
	private @Nullable UUID owner;

	CrystallizeShardEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
		this(entityType, world, null, null);
	}

	public CrystallizeShardEntity(class_1299<? extends class_1309> entityType, class_1937 world, Element element) {
		this(entityType, world, element, null);
	}

	public CrystallizeShardEntity(class_1299<? extends class_1309> entityType, class_1937 world, Element element, @Nullable class_1309 owner) {
		super(entityType, world);

		this.element = this.method_37908().field_9236 ? null : JavaScriptUtil.nullishCoalesing(element, Element.GEO);
		this.owner = ClassInstanceUtil.mapOrNull(owner, class_1309::method_5667);
	}

	public static CrystallizeShardEntity create(class_3218 world, @Nullable class_1309 owner, Element element, class_243 pos, class_3730 reason) {
		return SevenElementsEntityTypes.CRYSTALLIZE_SHARD.method_5888(
			world,
			shard -> {
				shard.element = element;
				shard.owner = ClassInstanceUtil.mapOrNull(owner, class_1309::method_5667);
			},
			MathHelper2.asBlockPos(pos),
			reason,
			true,
			false
		);
	}

	@Override
	public void method_5652(class_11372 view) {
		super.method_5652(view);

		view.method_71468("Element", Element.CODEC, this.element);
		view.method_71477("Owner", class_4844.field_40825, this.owner);
	}

	@Override
	public void method_5749(class_11368 view) {
		super.method_5749(view);

		this.element = view.method_71426("Element", Element.CODEC).orElse(this.element);
		this.owner = view.method_71426("Owner", class_4844.field_40825).orElse(this.owner);
	}

	@Override
	public void method_5773() {
		super.method_5773();

		this.idleAnimationState.method_41324(this.field_6012);

		this.checkCrystallizeShield();
		this.syncToPlayers();
	}

	@Override
	public boolean method_30949(class_1297 other) {
		return other instanceof CrystallizeShardEntity;
	}

	/**
	 * Gets the element of this {@code CrystallizeShardEntity}. <br> <br>
	 *
	 * This is guaranteed to only be nullable <b>if</b> the world is on the client, as the element
	 * is considered {@code null} until the sync packet is received from the server. <br> <br>
	 *
	 * While the element is considered {@code null}, the Crystallize Shard is not rendered. <br> <br>
	 */
	public @Nullable Element getElement() {
		return element;
	}

	public void syncFromPacket(SyncCrystallizeShardTypeS2CPayload packet) {
		this.element = packet.element;
	}

	public void syncToPlayers() {
		if (!(this.method_37908() instanceof class_3218)) return;

		final SyncCrystallizeShardTypeS2CPayload packet = new SyncCrystallizeShardTypeS2CPayload(this.method_5628(), this.element);

		for (final class_3222 otherPlayer : PlayerLookup.tracking(this))
			ServerPlayNetworking.send(otherPlayer, packet);
	}

	private void checkCrystallizeShield() {
		if (this.method_37908().field_9236) return;

		final List<class_1309> entities = ElementalReaction.getEntitiesInAoE(this, 1.0, e -> !(e instanceof SevenElementsEntity || e.method_5864().method_20210(SevenElementsEntityTypeTags.IGNORED_TARGETS)));
		final @Nullable class_1309 owner = this.getEntityFromUUID(this.owner);

		@Nullable class_1309 target = null;

		if (this.field_6012 > 300) {
			this.method_5650(class_5529.field_26998);
		} else if (this.field_6012 <= 150 && entities.contains(owner)) {
			target = owner;
		} else if (this.owner == null || this.field_6012 > 150) {
			target = entities
				.stream()
				.min(Comparator.comparingDouble(this::method_5739))
				.orElse(null);
		}

		if (target == null) return;

		final ElementComponent component = ElementComponent.KEY.get(target);

		component.setCrystallizeShield(element, SevenElements.getLevelMultiplier(this));

		this.method_37908()
			.method_8396(null, this.method_24515(), SevenElementsSoundEvents.CRYSTALLIZE_SHIELD, class_3419.field_15248, 1.0f, 1.0f);

		this.method_5650(class_5529.field_26998);
	}

	static {
		ElementComponent.denyElementsFor(CrystallizeShardEntity.class);
	}

	public static class SyncCrystallizeShardTypeS2CPayload implements class_8710 {
		public static final class_8710.class_9154<SyncCrystallizeShardTypeS2CPayload> ID = new class_8710.class_9154<>(
			SevenElements.identifier("s2c/sync_crystallize_shard_type")
		);

		public static final class_9139<class_9129, SyncCrystallizeShardTypeS2CPayload> CODEC = class_9139.method_56435(
			class_9135.field_49675, SyncCrystallizeShardTypeS2CPayload::entityId,
			class_9135.method_56368(Element.CODEC), inst -> inst.element,
			SyncCrystallizeShardTypeS2CPayload::new
		);

		private final int entityId;
		private final Element element;

		private SyncCrystallizeShardTypeS2CPayload(int entityId, Element element) {
			this.entityId = entityId;
			this.element = element;
		}

		@Override
		public class_9154<? extends class_8710> method_56479() {
			return ID;
		}

		public int entityId() {
			return entityId;
		}
	}
}
