package io.github.xrickastley.sevenelements.entity;

import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1306;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;

// Base class for all "special" entities: Crystallize Shard and Dendro Core
// Should technically extend Entity, but extends LivingEntity instead to NOT deal with more Networking and Spawn Packets.
public sealed class SevenElementsEntity
	extends class_1309
	permits DendroCoreEntity, CrystallizeShardEntity
{
	protected SevenElementsEntity(class_1299<? extends class_1309> entityType, class_1937 world) {
		super(entityType, world);
	}

	public static class_5132.class_5133 getAttributeBuilder() {
		return class_1309.method_26827()
			.method_26868(class_5134.field_23716, 1);
	}

	public int getAge() {
		return this.field_6012;
	}

	@Override
	public class_1306 method_6068() {
		return class_1306.field_6182;
	}

	@Override
	public void method_18380(class_4050 pose) {
		super.method_18380(class_4050.field_18076);
	}

	@Override
	public class_4050 method_18376() {
		return class_4050.field_18076;
	}

	@Override
	public void method_5673(class_1304 slot, class_1799 stack) {}

	@Override
	public class_1799 method_6118(class_1304 slot) {
		return class_1799.field_8037;
	}

	@Override
	public boolean method_6049(class_1293 effect) {
		return false;
	}

	@Override
	public boolean method_37222(class_1293 effect, class_1297 source) {
		return false;
	}

	@Override
	public void method_5768(class_3218 world) {
		this.method_5650(class_5529.field_26998);
	}

	@Override
	public boolean method_64397(class_3218 world, class_1282 source, float amount) {
		return false;
	}

	@Override
	public boolean method_30949(class_1297 other) {
		return false;
	}

	@Override
	public boolean method_30948(class_1297 entity) {
		return false;
	}

	@Override
	public boolean method_5810() {
		return false;
	}

	@Override
	public void method_5697(class_1297 entity) {}

	@Override
	public void method_6005(double strength, double x, double z) {}

	protected final @Nullable class_1309 getEntityFromUUID(UUID uuid) {
		return this.method_37908() instanceof final class_3218 world
			? ClassInstanceUtil.castOrNull(world.method_66347(uuid), class_1309.class)
			: null;
	}
}
