package io.github.xrickastley.sevenelements.renderer;

import java.util.ArrayList;
import java.util.List;

import org.joml.Matrix4f;

import io.github.xrickastley.sevenelements.util.ClientConfig;
import io.github.xrickastley.sevenelements.util.Color;
import io.github.xrickastley.sevenelements.util.Ease;
import io.github.xrickastley.sevenelements.util.TextHelper;

import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_327.class_6415;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5481;
import net.minecraft.class_638;
import net.minecraft.class_7833;

public final class WorldTextRenderer {
	private final List<Entry> entries = new ArrayList<>();

	public void render(WorldRenderContext context) {
		final class_4184 camera = context.camera();
		final class_4587 matrixStack = new class_4587();

		matrixStack.method_22903();

		// Implement legacy renderWorld transforms.
		matrixStack.method_22907(class_7833.field_40714.rotationDegrees(camera.method_19329()));
		matrixStack.method_22907(class_7833.field_40716.rotationDegrees(camera.method_19330() + 180.0F));

		entries.forEach(entry -> entry.render(camera, context.tickCounter().method_60637(false), matrixStack));

		matrixStack.method_22909();
	}

	public void tick(class_638 world) {
		entries.forEach(Entry::tick);
		entries.removeIf(Entry::shouldRemove);
	}

	public WorldTextRenderer addEntry(Entry entry) {
		this.entries.add(entry);

		return this;
	}

	public static void drawText(final class_4184 camera, final class_4587 matrices, final class_4597 vertexConsumers, final class_5481 text, final double x, final double y, final double z, final int color, final float size, final boolean center, final float offset, final boolean visibleThroughObjects) {
		final class_310 client = class_310.method_1551();
		final class_327 textRenderer = client.field_1772;
		final ClientConfig config = ClientConfig.get();

		final double d = camera.method_19326().field_1352;
		final double e = camera.method_19326().field_1351;
		final double f = camera.method_19326().field_1350;

		final float scale = (float) (size * config.rendering.text.globalTextScale);

		matrices.method_22903();
		matrices.method_46416((float) (x - d), (float) (y - e), (float) (z - f));
		matrices.method_34425(new Matrix4f().rotation(camera.method_23767()));
		matrices.method_22905(scale, -scale, scale);

		float g = center ? (-textRenderer.method_30880(text) / 2.0f) : 0.0f;
		g -= offset / size;

		textRenderer.method_22942(text, g, 0.0f, color, false, matrices.method_23760().method_23761(), vertexConsumers, visibleThroughObjects ? class_6415.field_33994 : class_6415.field_33993, 0, 15728880);

		matrices.method_22909();
	}

	public static abstract class Entry {
		protected final double x;
		protected final double y;
		protected final double z;
		protected final Color color;
		protected int age;

		Entry(double x, double y, double z, Color color) {
			this.x = x;
			this.y = y;
			this.z = z;
			this.color = color;
			this.age = 0;
		}

		protected abstract void render(class_4184 camera, float tickDelta, class_4587 matrices);

		protected void tick() {
			this.age++;
		}

		protected abstract boolean shouldRemove();
	}

	public static final class ReactionText extends Entry {
		protected final class_2561 text;
		protected final int maxAge = 30;
		protected final int fadeAge = maxAge - 15;
		protected final int scaleAge = 8;

		public ReactionText(double x, double y, double z, Color color, class_2561 text) {
			super(x, y, z, color);

			this.text = text;
		}

		@Override
		protected void render(class_4184 camera, float tickDelta, class_4587 matrices) {
			final class_310 client = class_310.method_1551();
			final class_4597.class_4598 immediate = client.method_22940().method_23000();

			final float deltaTime = age + tickDelta;

			final double alpha = Math.max(0.0f, class_3532.method_16436((deltaTime - fadeAge) / (maxAge - fadeAge), 1.0, 0.0));
			final double scale = 1.25 - (Ease.IN_OUT_QUART.applyLerpProgress(deltaTime / scaleAge, 0, 1) * 0.5);

			if (alpha <= 0f || scale <= 0f) return;

			final double x = this.x;
			final double y = this.y + Ease.OUT_SINE.applyLerpProgress(deltaTime, 0, maxAge) * 0.75f;
			final double z = this.z;

			final int color = this.color
				.multiply(1, 1, 1, alpha)
				.asARGB();

			WorldTextRenderer.drawText(camera, matrices, immediate, this.text.method_30937(), x, y, z, color, 0.04f * (float) scale, true, 0f, true);

			immediate.method_22993();
		}

		@Override
		protected boolean shouldRemove() {
			return age > maxAge;
		}
	}

	public static final class DamageText extends Entry {
		protected final int maxAge = 30;
		protected final int fadeAge = maxAge - 15;
		protected final int scaleAge = 12;
		protected final class_2561 amount;
		protected final double scale;

		public DamageText(double x, double y, double z, Color color, double amount, double scale) {
			super(x, y, z, color);

			final ClientConfig config = ClientConfig.get();
			final String damageFormat = config.developer.commafyDamage
				? "%,.0f"
				: "%.0f";

			this.amount = TextHelper.font(String.format(damageFormat, Math.max(amount, 1)), TextHelper.GENSHIN_FONT);
			this.scale = scale;
		}

		@Override
		protected void render(class_4184 camera, float tickDelta, class_4587 matrices) {
			final class_4597.class_4598 immediate = SevenElementsRenderLayer.getWorldTextImmediate();

			final float deltaTime = age + tickDelta;

			final double alpha = Math.max(0.0f, class_3532.method_16436((deltaTime - fadeAge) / (maxAge - fadeAge), 1.0, 0.0));
			final double scale = (1.25 - (Ease.IN_OUT_QUART.applyLerpProgress(deltaTime / scaleAge, 0, 1) * 0.5)) * this.scale;

			if (alpha <= 0f || scale <= 0f) return;

			final double x = this.x;
			final double y = this.y + Ease.OUT_SINE.applyLerpProgress(deltaTime, 0, maxAge) * 0.75f;
			final double z = this.z;

			final int color = this.color
				.multiply(1, 1, 1, alpha)
				.asARGB();

			WorldTextRenderer.drawText(camera, matrices, immediate, this.amount.method_30937(), x, y, z, color, 0.04f * (float) scale, true, 0f, true);

			immediate.method_22993();
		}

		@Override
		protected boolean shouldRemove() {
			return age > maxAge;
		}
	}
}
