/*
 * Decompiled with CFR 0.152.
 */
package io.github.xrickastley.sevenelements.element;

import com.mojang.serialization.Codec;
import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.events.ElementEvents;
import io.github.xrickastley.sevenelements.exception.ElementalApplicationOperationException;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;
import io.github.xrickastley.sevenelements.util.TextHelper;
import io.github.xrickastley.sevenelements.util.ViewHelper;
import java.text.DecimalFormat;
import java.util.UUID;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2561;
import net.minecraft.class_4844;
import org.jetbrains.annotations.Nullable;

public final class DurationElementalApplication
extends ElementalApplication {
    private double duration;

    DurationElementalApplication(class_1309 entity, Element element, UUID uuid, double gaugeUnits, double duration) {
        super(ElementalApplication.Type.DURATION, entity, element, uuid, gaugeUnits, true);
        this.duration = duration;
    }

    static ElementalApplication fromData(class_1309 entity, class_11368 view, long syncedAt) {
        Element element = ViewHelper.get(view, "Element", Element.CODEC);
        UUID uuid = (UUID)ViewHelper.get(view, "UUID", class_4844.field_40825);
        double gaugeUnits = (Double)ViewHelper.get(view, "GaugeUnits", Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE));
        double duration = (Double)ViewHelper.get(view, "Duration", Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE));
        DurationElementalApplication application = new DurationElementalApplication(entity, element, uuid, gaugeUnits, duration);
        application.currentGauge = (Double)ViewHelper.get(view, "CurrentGauge", Codec.doubleRange((double)0.0, (double)Double.MAX_VALUE));
        application.appliedAt = (Long)ViewHelper.get(view, "AppliedAt", Codec.LONG);
        return application;
    }

    public double getDuration() {
        return this.duration;
    }

    @Override
    protected double getDefaultDecayRate() {
        return 0.0;
    }

    @Override
    public int getRemainingTicks() {
        return (int)((double)this.appliedAt + this.duration - (double)this.entity.method_37908().method_8510());
    }

    @Override
    public class_2561 getText(@Nullable DecimalFormat gaugeFormat, @Nullable DecimalFormat durationFormat) {
        gaugeFormat = JavaScriptUtil.nullishCoalesing(gaugeFormat, GAUGE_UNIT_FORMAT);
        durationFormat = JavaScriptUtil.nullishCoalesing(durationFormat, DURATION_FORMAT);
        return TextHelper.color(class_2561.method_43469((String)"formats.seven-elements.elemental_application.duration", (Object[])new Object[]{gaugeFormat.format(this.currentGauge), this.element.getString(), durationFormat.format(this.duration / 20.0)}), this.element.getDamageColor());
    }

    public class_2561 getTimerText() {
        return this.getTimerText(GAUGE_UNIT_FORMAT, DURATION_FORMAT);
    }

    public class_2561 getTimerText(@Nullable String gaugeFormat) {
        return this.getTimerText(ClassInstanceUtil.mapOrNull(gaugeFormat, DecimalFormat::new), DURATION_FORMAT);
    }

    public class_2561 getTimerText(@Nullable DecimalFormat gaugeFormat) {
        return this.getTimerText(gaugeFormat, DURATION_FORMAT);
    }

    public class_2561 getTimerText(@Nullable String gaugeFormat, @Nullable String durationFormat) {
        return this.getTimerText(ClassInstanceUtil.mapOrNull(gaugeFormat, DecimalFormat::new), ClassInstanceUtil.mapOrNull(durationFormat, DecimalFormat::new));
    }

    public class_2561 getTimerText(@Nullable DecimalFormat gaugeFormat, @Nullable DecimalFormat durationFormat) {
        gaugeFormat = JavaScriptUtil.nullishCoalesing(gaugeFormat, GAUGE_UNIT_FORMAT);
        durationFormat = JavaScriptUtil.nullishCoalesing(durationFormat, DURATION_FORMAT);
        return TextHelper.color(class_2561.method_43469((String)"formats.seven-elements.elemental_application.duration.timer", (Object[])new Object[]{gaugeFormat.format(this.currentGauge), this.element.getString(), durationFormat.format((double)this.getRemainingTicks() / 20.0)}), this.element.getDamageColor());
    }

    @Override
    public boolean isEmpty() {
        return this.currentGauge <= 0.0 || (double)this.entity.method_37908().method_8510() >= (double)this.appliedAt + this.duration;
    }

    @Override
    public void reapply(ElementalApplication application) {
        if (application.element != this.element) {
            throw new ElementalApplicationOperationException(ElementalApplicationOperationException.Operation.REAPPLICATION_INVALID_ELEMENT, this, application);
        }
        if (application.type != this.type || !(application instanceof DurationElementalApplication)) {
            throw new ElementalApplicationOperationException(ElementalApplicationOperationException.Operation.REAPPLICATION_INVALID_TYPES, this, application);
        }
        DurationElementalApplication durationApp = (DurationElementalApplication)application;
        this.currentGauge = this.gaugeUnits = Math.max(this.gaugeUnits, application.gaugeUnits);
        this.duration = durationApp.duration;
        this.appliedAt = durationApp.appliedAt;
        ((ElementEvents.ElementReapplied)ElementEvents.REAPPLIED.invoker()).onElementReapplied(this.element, this);
        ElementComponent.sync((class_1297)this.entity);
    }

    @Override
    public ElementalApplication asAura() {
        throw new UnsupportedOperationException("This method is unsupported on Elemental Applications with a DURATION type!");
    }

    @Override
    public ElementalApplication asNonAura() {
        throw new UnsupportedOperationException("This method is unsupported on Elemental Applications with a DURATION type!");
    }

    @Override
    public void writeData(class_11372 view) {
        super.writeData(view);
        view.method_71463("Duration", this.duration);
    }

    @Override
    public void updateFromData(class_11368 view, long syncedAt) {
        super.updateFromData(view, syncedAt);
        ElementalApplication application = ElementalApplications.fromData(this.entity, view, syncedAt);
        this.duration = ((DurationElementalApplication)application).duration;
        this.appliedAt = application.appliedAt;
    }

    public String toString() {
        return String.format("%s@%s[type=DURATION, element=%s, gaugeUnits=%s, duration=%.2f]", this.getClass().getSimpleName(), Integer.toHexString(this.hashCode()), this.getElement().toString(), this.getGaugeUnits(), this.getDuration());
    }
}

