package io.github.xrickastley.sevenelements;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.component.ElementComponentImpl;
import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import io.github.xrickastley.sevenelements.component.FrozenEffectComponent;
import io.github.xrickastley.sevenelements.component.FrozenEffectComponentImpl;
import net.minecraft.class_1309;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.entity.EntityComponentInitializer;
import dev.onyxstudios.cca.api.v3.item.ItemComponentFactoryRegistry;
import dev.onyxstudios.cca.api.v3.item.ItemComponentInitializer;


public class SevenElementsCCAComponents implements EntityComponentInitializer, ItemComponentInitializer {
	@Override
	public void registerEntityComponentFactories(EntityComponentFactoryRegistry registry) {
		registry.registerFor(class_1309.class, ElementComponent.KEY, ElementComponentImpl::new);
		registry.registerFor(class_1309.class, FrozenEffectComponent.KEY, FrozenEffectComponentImpl::new);
	}

	@Override
	public void registerItemComponentFactories(ItemComponentFactoryRegistry registry) {
		registry.register(i -> true, ElementalInfusionComponent.KEY, ElementalInfusionComponent::new);
	}
}
