package io.github.xrickastley.sevenelements.mixin.client;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.renderer.genshin.SpecialEffectsRenderer;
import io.github.xrickastley.sevenelements.util.ClientConfig;
import io.github.xrickastley.sevenelements.util.Functions;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;

@Mixin(class_1309.class)
public abstract class LivingEntityMixin extends class_1297 {
	public LivingEntityMixin(final class_1299<? extends class_1309> entityType, final class_1937 world) {
		super(entityType, world);
		throw new AssertionError();
	}

	@Inject(
		method = "tick",
		at = @At("TAIL")
	)
	public void addEffectRendering(CallbackInfo ci) {
		// Sanity check for isClient in case
		if (!this.method_37908().field_9236 || !ClientConfig.getEffectRenderType().allowsNormalEffects() || !SpecialEffectsRenderer.shouldRender(this)) return;

		final ElementComponent component = ElementComponent.KEY.get(this);

		component
			.getPrioritizedElements()
			.forEach(Functions.composeConsumer(ElementalApplication::getElement, Functions.withArgument(Element::renderEffects, (class_1309)(class_1297) this)));
	}
}
