package io.github.xrickastley.sevenelements.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.DoubleArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;

import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2960;
import net.minecraft.class_6880.class_6883;
import net.minecraft.class_7157;
import net.minecraft.class_7733;
import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementHolder;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.InternalCooldownTag;
import io.github.xrickastley.sevenelements.element.InternalCooldownType;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.registry.SevenElementsRegistryKeys;
import io.github.xrickastley.sevenelements.util.Array;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.Functions;
import io.github.xrickastley.sevenelements.util.JavaScriptUtil;

import static net.minecraft.class_2170.method_9244;
import static net.minecraft.class_2170.method_9247;

public class ElementCommand {
	public static void register(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess) {
		dispatcher.register(
			class_2170
				.method_9247("element")
				.requires(cs -> cs.method_9259(2))
				.then(
					method_9247("apply")
					.then(
						method_9244("target", class_2186.method_9309())
						.then(
							method_9244("element", ElementArgumentType.element())
							.then(
								method_9244("gaugeUnits", DoubleArgumentType.doubleArg(0))
								.executes(ElementCommand::applyGaugeUnit)
								.then(
									method_9247("gaugeUnit")
									.executes(ElementCommand::applyGaugeUnit)
									.then(
										method_9244("isAura", BoolArgumentType.bool())
										.executes(ElementCommand::applyGaugeUnit)
									)
								)
								.then(
									method_9247("duration")
									.then(
										method_9244("duration", IntegerArgumentType.integer(0))
										.executes(ElementCommand::applyDuration)
									)
								)
							)
						)
					)
				)
				.then(
					method_9247("remove")
					.then(
						method_9244("target", class_2186.method_9309())
						.executes(ElementCommand::removeAllElements)
						.then(
							method_9244("element", ElementArgumentType.element())
							.executes(ElementCommand::removeElement)
						)
					)
				)
				.then(
					method_9247("reduce")
					.then(
						method_9244("target", class_2186.method_9309())
						.then(
							method_9244("element", ElementArgumentType.element())
							.then(
								method_9244("gaugeUnits", DoubleArgumentType.doubleArg(0))
								.executes(ElementCommand::reduceElement)
							)
						)
					)
				)
				.then(
					method_9247("query")
					.then(
						method_9244("target", class_2186.method_9309())
						.executes(ElementCommand::queryElements)
						.then(
							method_9244("element", ElementArgumentType.element())
							.executes(ElementCommand::queryElement)
						)
					)
				)
				.then(
					method_9247("infusion")
					.then(
						method_9247("apply")
						.then(
							method_9244("entity", class_2186.method_9309())
							.then(
								method_9244("element", ElementArgumentType.element())
								.then(
									method_9244("gaugeUnits", DoubleArgumentType.doubleArg(0))
									.executes(ElementCommand::infuseGaugeUnit)
									.then(
										method_9247("gaugeUnit")
										.executes(ElementCommand::infuseGaugeUnit)
										.then(
											method_9244("tag", InternalCooldownTagType.tag())
											.executes(ElementCommand::infuseGaugeUnit)
											.then(
												method_9244("type", class_7733.method_45603(registryAccess, SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE))
												.executes(ElementCommand::infuseGaugeUnit)
											)
										)
									)
									.then(
										method_9247("duration")
										.then(
											method_9244("duration", IntegerArgumentType.integer(0))
											.executes(ElementCommand::infuseDuration)
											.then(
												method_9244("tag", InternalCooldownTagType.tag())
												.executes(ElementCommand::infuseDuration)
												.then(
													method_9244("type", class_7733.method_45603(registryAccess, SevenElementsRegistryKeys.INTERNAL_COOLDOWN_TYPE))
													.executes(ElementCommand::infuseDuration)
												)
											)
										)
									)
								)
							)
						)
					)
					.then(
						method_9247("remove")
						.then(
							method_9244("entity", class_2186.method_9309())
							.executes(ElementCommand::infuseRemove)
						)
					)
				)
		);
	}

	private static int applyGaugeUnit(CommandContext<class_2168> context) throws CommandSyntaxException {
		final class_1297 entity = class_2186.method_9313(context, "target");
		final Element element = ElementArgumentType.getElement(context, "element");
		final double gaugeUnits = DoubleArgumentType.getDouble(context, "gaugeUnits");
		final boolean aura = CommandUtils.getOrDefault(context, "isAura", Boolean.class, true);

		if (!(entity instanceof final class_1309 target))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.failed.entity", entity.method_5476()));

		final ElementComponent component = ElementComponent.KEY.get(target);
		final ElementalApplication application = ElementalApplications.gaugeUnits(target, element, gaugeUnits, aura);
		final List<ElementalReaction> reactions = component.addElementalApplication(application, InternalCooldownContext.ofNone());

		return reactions.isEmpty()
			? CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.apply", application.getText(), entity.method_5476()), true)
			: CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.apply.reactions", application.getText(), entity.method_5476(), class_2564.method_10884(reactions, Functions.compose(ElementalReaction::getId, class_2960::toString, class_2561::method_43470))), true);
	}

	private static int applyDuration(CommandContext<class_2168> context) throws CommandSyntaxException {
		final class_1297 entity = class_2186.method_9313(context, "target");
		final Element element = ElementArgumentType.getElement(context, "element");
		final double gaugeUnits = DoubleArgumentType.getDouble(context, "gaugeUnits");
		final int duration = IntegerArgumentType.getInteger(context, "duration");

		if (!(entity instanceof final class_1309 target))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.failed.entity", entity.method_5476()));

		final ElementComponent component = ElementComponent.KEY.get(target);
		final ElementalApplication application = ElementalApplications.duration(target, element, gaugeUnits, duration);
		final List<ElementalReaction> reactions = component.addElementalApplication(application, InternalCooldownContext.ofNone());

		return reactions.isEmpty()
			? CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.apply", element.getText(true), entity.method_5476()), true)
			: CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.apply.reactions", element.getText(true), entity.method_5476(), class_2564.method_10884(reactions, Functions.compose(ElementalReaction::getId, class_2960::toString, class_2561::method_43470))), true);
	}

	private static int removeAllElements(CommandContext<class_2168> context) throws CommandSyntaxException {
		final class_1297 entity = class_2186.method_9313(context, "target");

		if (!(entity instanceof final class_1309 target))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.failed.entity", entity.method_5476()));

		final ElementComponent component = ElementComponent.KEY.get(target);
		final int removedElements = component
			.getAppliedElements()
			.stream()
			.map(Functions.compose(ElementalApplication::getElement, component::getElementHolder))
			.peek(Functions.withArgument(ElementHolder::setElementalApplication, null))
			// Apparently Stream#count can choose to NOT traverse the Stream elements.
			.collect(Collectors.summingInt(h -> 1));

		ElementComponent.sync(target);

		return removedElements > 0
			? CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.remove.multiple.success", entity.method_5476(), removedElements), true)
			: CommandUtils.sendError(context, class_2561.method_43469("commands.element.remove.multiple.none", entity.method_5476()));
	}

	private static int removeElement(CommandContext<class_2168> context) throws CommandSyntaxException {
		final class_1297 entity = class_2186.method_9313(context, "target");
		final Element element = ElementArgumentType.getElement(context, "element");

		if (!(entity instanceof final class_1309 target))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.failed.entity", entity.method_5476()));

		final ElementComponent component = ElementComponent.KEY.get(target);
		final ElementHolder holder = component.getElementHolder(element);

		if (!holder.hasElementalApplication())
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.failed.none", entity.method_5476(), element.getText(true)));

		holder.setElementalApplication(null);

		ElementComponent.sync(entity);

		return CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.remove", element.getText(true), entity.method_5476()), true);
	}

	private static int reduceElement(CommandContext<class_2168> context) throws CommandSyntaxException {
		final class_1297 entity = class_2186.method_9313(context, "target");
		final Element element = ElementArgumentType.getElement(context, "element");
		final double gaugeUnits = DoubleArgumentType.getDouble(context, "gaugeUnits");

		if (!(entity instanceof final class_1309 target))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.failed.entity", entity.method_5476()));

		final ElementComponent component = ElementComponent.KEY.get(target);
		final ElementHolder holder = component.getElementHolder(element);

		if (!holder.hasElementalApplication())
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.failed.none", entity.method_5476(), element.getText(true)));

		final double reducedGauge = holder
			.getElementalApplication()
			.reduceGauge(gaugeUnits);

		ElementComponent.sync(entity);

		return CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.reduce", entity.method_5476(), element.getText(true), reducedGauge), true);
	}

	private static int queryElements(CommandContext<class_2168> context) throws CommandSyntaxException {
		final class_1297 entity = class_2186.method_9313(context, "target");

		if (!(entity instanceof final class_1309 target))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.failed.entity", entity.method_5476()));

		final ElementComponent component = ElementComponent.KEY.get(target);
		final Array<ElementalApplication> appliedElements = component.getAppliedElements();

		if (appliedElements.isEmpty())
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.query.multiple.none", entity.method_5476()));

		return CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.query.multiple.success", entity.method_5476(), class_2564.method_10884(appliedElements, ElementalApplications::getTimerText)), true);
	}

	private static int queryElement(CommandContext<class_2168> context) throws CommandSyntaxException {
		final class_1297 entity = class_2186.method_9313(context, "target");
		final Element element = ElementArgumentType.getElement(context, "element");

		if (!(entity instanceof final class_1309 target))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.failed.entity", entity.method_5476()));

		final ElementComponent component = ElementComponent.KEY.get(target);
		final @Nullable ElementalApplication application = component.getElementHolder(element).getElementalApplication();

		if (application == null)
			return CommandUtils.sendError(context, class_2561.method_43469("commands.element.query.single.none", entity.method_5476(), element.getText(true)));

		return CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.query.single.success", entity.method_5476(), ElementalApplications.getTimerText(application)), true);
	}

	private static int infuseGaugeUnit(CommandContext<class_2168> context) throws CommandSyntaxException {
		final Element element = ElementArgumentType.getElement(context, "element");
		final double gaugeUnits = DoubleArgumentType.getDouble(context, "gaugeUnits");
		final InternalCooldownTag tag = InternalCooldownTagType.getTagOrDefault(context, "tag", InternalCooldownTag.NONE);

		final @Nullable class_6883<InternalCooldownType> typeRef = ClassInstanceUtil.cast(CommandUtils.getOrDefault(context, "type", class_6883.class, null));
		final InternalCooldownType type = JavaScriptUtil.nullishCoalesing(
			ClassInstanceUtil.mapOrNull(typeRef, class_6883::comp_349),
			InternalCooldownType.DEFAULT
		);

		final class_1297 entity = class_2186.method_9313(context, "entity");

		if (!(entity instanceof final class_1309 livingEntity))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.enchant.failed.entity", entity.method_5476()));

		final class_1799 stack = livingEntity.method_6047();

		if (stack.method_7960())
			return CommandUtils.sendError(context, class_2561.method_43469("commands.enchant.failed.itemless", entity.method_5476()));

		final ElementalApplication.Builder infusionBuilder = ElementalApplications.builder()
			.setType(ElementalApplication.Type.GAUGE_UNIT)
			.setElement(element)
			.setGaugeUnits(gaugeUnits)
			.setAsAura(false);

		final InternalCooldownContext.Builder icdBuilder = InternalCooldownContext.builder()
			.setTag(tag)
			.setType(type);

		ElementalInfusionComponent.applyInfusion(stack, infusionBuilder, icdBuilder);

		final class_2561 elementText = ElementalApplication.Builder.getText(infusionBuilder);
		final class_2561 icdText = class_2561.method_43473()
			.method_10852(tag.getText(class_124.field_1068))
			.method_27693("/")
			.method_10852(type.getText());

		return CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.infuse.apply.success", elementText, icdText, entity.method_5476()), true);
	}

	private static int infuseDuration(CommandContext<class_2168> context) throws CommandSyntaxException {
		final Element element = ElementArgumentType.getElement(context, "element");
		final double gaugeUnits = DoubleArgumentType.getDouble(context, "gaugeUnits");
		final int duration = IntegerArgumentType.getInteger(context, "duration");
		final InternalCooldownTag tag = InternalCooldownTagType.getTagOrDefault(context, "tag", InternalCooldownTag.NONE);

		final @Nullable class_6883<InternalCooldownType> typeRef = ClassInstanceUtil.cast(CommandUtils.getOrDefault(context, "type", class_6883.class, null));
		final InternalCooldownType type = JavaScriptUtil.nullishCoalesing(
			ClassInstanceUtil.mapOrNull(typeRef, class_6883::comp_349),
			InternalCooldownType.DEFAULT
		);

		final class_1297 entity = class_2186.method_9313(context, "entity");

		if (!(entity instanceof final class_1309 livingEntity))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.enchant.failed.entity", entity.method_5476()));

		final class_1799 stack = livingEntity.method_6047();

		if (stack.method_7960())
			return CommandUtils.sendError(context, class_2561.method_43469("commands.enchant.failed.itemless", entity.method_5476()));

		final ElementalApplication.Builder infusionBuilder = ElementalApplications.builder()
			.setType(ElementalApplication.Type.DURATION)
			.setElement(element)
			.setGaugeUnits(gaugeUnits)
			.setDuration(duration);

		final InternalCooldownContext.Builder icdBuilder = InternalCooldownContext.builder()
			.setTag(tag)
			.setType(type);

		ElementalInfusionComponent.applyInfusion(stack, infusionBuilder, icdBuilder);

		final class_2561 elementText = ElementalApplication.Builder.getText(infusionBuilder);
		final class_2561 icdText = class_2561.method_43473()
			.method_10852(tag.getText())
			.method_27693("/")
			.method_10852(type.getText());

		return CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.infuse.apply.success", elementText, icdText, entity.method_5476()), true);
	}

	private static int infuseRemove(CommandContext<class_2168> context) throws CommandSyntaxException {
		final class_1297 entity = class_2186.method_9313(context, "entity");

		if (!(entity instanceof final class_1309 livingEntity))
			return CommandUtils.sendError(context, class_2561.method_43469("commands.enchant.failed.entity", entity.method_5476()));

		final class_1799 stack = livingEntity.method_6047();

		if (stack.method_7960())
			return CommandUtils.sendError(context, class_2561.method_43469("commands.enchant.failed.itemless", entity.method_5476()));

		return ElementalInfusionComponent.removeInfusion(stack)
			? CommandUtils.sendFeedback(context, class_2561.method_43469("commands.element.infuse.remove.success", entity.method_5476()), true)
			: CommandUtils.sendError(context, class_2561.method_43469("commands.element.infuse.remove.none", entity.method_5476()));
	}
}
