package io.github.xrickastley.sevenelements.effect;

import io.github.xrickastley.sevenelements.component.FrozenEffectComponent;
import io.github.xrickastley.sevenelements.element.Element;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_4081;
import net.minecraft.class_5131;
import net.minecraft.class_5134;

public final class FrozenStatusEffect extends ElementalStatusEffect {
	FrozenStatusEffect() {
		super(class_4081.field_18272, 0x84e8f9, Element.FREEZE);

		this.method_5566(class_5134.field_23719, "26fbc919-06ff-4775-aaf0-e3a80fd045d0", -1, class_1322.class_1323.field_6331);
		this.method_5566(class_5134.field_23721, "dcaa96b5-a028-452a-9de0-c901e5b52e21", Integer.MIN_VALUE, class_1322.class_1323.field_6328);
	}

	@Override
	public void method_5555(class_1309 entity, class_5131 container, int amplifier) {
		super.method_5555(entity, container, amplifier);

		FrozenEffectComponent.KEY.get(entity).freeze();
	}

	@Override
	public void method_5562(class_1309 entity, class_5131 attributes, int amplifier) {
		super.method_5562(entity, attributes, amplifier);

		FrozenEffectComponent.KEY.get(entity).unfreeze();
	}

	@Override
	public void onRemoved(class_1309 entity, int amplifier) {
		super.onRemoved(entity, amplifier);

		FrozenEffectComponent.KEY.get(entity).unfreeze();
	}

	@Override
	public void method_5572(class_1309 entity, int amplifier) {
		if (entity.method_6112(SevenElementsStatusEffects.FROZEN).method_5584() == 1 && entity instanceof final class_1308 mob)
			mob.method_5977(false);
	}

	@Override
	public boolean method_5552(int duration, int amplifier) {
		return true;
	}
}
