package io.github.xrickastley.sevenelements.element.reaction;

import org.jetbrains.annotations.Nullable;

import io.github.xrickastley.sevenelements.element.ElementalApplication;
import net.minecraft.class_1309;
import net.minecraft.class_1937;

public abstract class AdditiveElementalReaction extends ElementalReaction {
	final double amplifier;

	protected AdditiveElementalReaction(Settings settings, double amplifier) {
		super(settings);

		this.amplifier = amplifier;
	}

	public float applyAmplifier(class_1309 entity, float damage) {
		return (float) applyAmplifier(entity.method_37908(), (double) damage);
	}

	public float applyAmplifier(class_1937 world, float damage) {
		return (float) applyAmplifier(world, (double) damage);
	}

	public double applyAmplifier(class_1309 entity, double damage) {
		return applyAmplifier(entity.method_37908(), damage);
	}

	public double applyAmplifier(class_1937 world, double damage) {
		return getDamageBonus(world) + damage;
	}

	public double getAmplifier() {
		return this.amplifier;
	}

	public double getDamageBonus(class_1937 world) {
		return ElementalReaction.getReactionDamage(world, amplifier);
	}

	@Override
	protected void onReaction(class_1309 entity, ElementalApplication auraElement, ElementalApplication triggeringElement, double reducedGauge, @Nullable class_1309 origin) {}
}
