package io.github.xrickastley.sevenelements.interfaces;

import java.util.stream.Stream;
import net.minecraft.class_1282;
import org.jetbrains.annotations.Nullable;

/**
 * An interface for classes that wrap around Minecraft's {@link class_1282} class.
 */
public interface DamageSourceWrapper {
	/**
	 * Recursively gets the possible {@code DamageSource} instances of the provided
	 * {@code DamageSource} and return them as a {@code Stream}. <br> <br>
	 *
	 * The {@code Stream} will terminate when
	 * {@link DamageSourceWrapper#getOriginalSource DamageSourceWrapper#getOriginalSource} returns
	 * a value that is not an instance of {@code DamageSource}, normally {@code null}.
	 *
	 * @param source The {@code DamageSource} to recursively get all possible {@code DamageSource} instances of.
	 */
	public static Stream<class_1282> getDamageSources(final class_1282 source) {
		return Stream.iterate(
			source,
			s -> s instanceof class_1282,
			s -> s instanceof final DamageSourceWrapper wrapper
				? wrapper.getOriginalSource()
				: null
		);
	}

	/**
	 * Returns the {@code DamageSource} that was used to create this {@code DamageSourceWrapper},
	 * or {@code null} if a {@code DamageSource} wasn't used.
	 */
	public @Nullable class_1282 getOriginalSource();
}
