package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.llamalad7.mixinextras.sugar.Local;
import net.minecraft.class_1297;
import net.minecraft.class_1665;
import net.minecraft.class_1671;
import net.minecraft.class_1764;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;

@Mixin(class_1764.class)
public class CrossbowItemMixin {
	@ModifyReturnValue(
		method = "createArrow",
		at = @At(
			value = "RETURN",
			ordinal = 0
		)
	)
	private static class_1665 addInfusionToFireworkRocket(class_1665 original, @Local(ordinal = 0, argsOnly = true) class_1799 weaponStack) {
		original.sevenelements$setOriginStack(weaponStack);

		return original;
	}

	@WrapOperation(
		method = "shoot",
		at = @At(
			value = "NEW",
			args = "class=net/minecraft/entity/projectile/FireworkRocketEntity"
		)
	)
	private static class_1671 addInfusionToFireworkRocket(class_1937 world, class_1799 stack, class_1297 entity, double x, double y, double z, boolean shotAtAngle, Operation<class_1671> original, @Local(ordinal = 0, argsOnly = true) class_1799 crossbow) {
		final class_1671 firework = original.call(world, stack, entity, x, y, z, shotAtAngle);

		firework.sevenelements$setOriginStack(crossbow);

		return firework;
	}
}
