package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.mojang.authlib.GameProfile;

import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;

@Mixin(value = class_1657.class, priority = Integer.MIN_VALUE)
public abstract class PrioritizedPlayerEntityMixin extends class_1309 {
	public PrioritizedPlayerEntityMixin(final class_1937 world, final class_2338 pos, final float yaw, final GameProfile gameProfile) {
		super(class_1299.field_6097, world);

		throw new AssertionError();
	}

	@Inject(
		method = "isBlockBreakingRestricted",
		at = @At("HEAD"),
		cancellable = true
	)
	// Prioritized since Frozen **MUST** disable movements and actions.
	private void frozenPreventsBreakingBlocks(CallbackInfoReturnable<Boolean> info) {
		if (this.method_6059(SevenElementsStatusEffects.FROZEN)) info.setReturnValue(true);
	}

	@ModifyExpressionValue(
		method = "attack",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/damage/DamageSources;playerAttack(Lnet/minecraft/entity/player/PlayerEntity;)Lnet/minecraft/entity/damage/DamageSource;"
		)
	)
	public class_1282 applyPlayerElementalInfusions(class_1282 source, @Local(argsOnly = true) class_1297 target) {
		return target instanceof final class_1309 livingTarget
			? ElementComponent.applyElementalInfusions(source, livingTarget).shouldInfuse(false)
			: source;
	}
}
