package io.github.xrickastley.sevenelements.util;

import io.github.xrickastley.sevenelements.SevenElements;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public final class TextHelper {
	public static final class_2960 GENSHIN_FONT = SevenElements.identifier("genshin");

	public static class_5250 font(String text, class_2960 font) {
		return font(class_2561.method_43470(text), font);
	}

	public static class_5250 font(class_5250 text, class_2960 font) {
		return text.method_10862(text.method_10866().method_27704(font));
	}

	public static class_5250 gradient(String text, int start, int end) {
		final class_5250 result = class_2561.method_43473();

		final int startR = (start >>> 16) & 0xFF;
		final int startG = (start >>> 8) & 0xFF;
		final int startB = start & 0xFF;

		final int endR = (end >>> 16) & 0xFF;
		final int endG = (end >>> 8) & 0xFF;
		final int endB = end & 0xFF;

		for (int i = 0; i < text.length(); i++) {
			final double step = i / ((double) text.length() - 1);

			final int r = (int) Math.round(startR + (endR - startR) * step);
			final int g = (int) Math.round(startG + (endG - startG) * step);
			final int b = (int) Math.round(startB + (endB - startB) * step);

			final int color = (r << 16) | (g << 8) | b;

			result.method_10852(
				class_2561.method_43470(String.valueOf(text.charAt(i)))
					.method_27696(class_2583.field_24360.method_36139(color))
			);
		}

		return result;
	}

	public static class_5250 reaction(String translationKey, String color) {
		return TextHelper.reaction(translationKey, Color.fromRGBAHex(color));
	}

	public static class_5250 reaction(String translationKey, Color color) {
		return TextHelper
			.font(class_2561.method_43471(translationKey), TextHelper.GENSHIN_FONT)
			.method_27696(class_2583.field_24360.method_36139(color.asRGB()));
	}

	public static class_5250 color(String text, Color color) {
		return TextHelper.color(text, color.asRGB());
	}

	public static class_5250 color(String text, int rgbColor) {
		return class_2561.method_43470(text).method_27696(class_2583.field_24360.method_36139(rgbColor));
	}

	public static class_5250 color(class_5250 text, Color color) {
		return TextHelper.color(text, color.asRGB());
	}

	public static class_5250 color(class_5250 text, int rgbColor) {
		return text.method_27696(text.method_10866().method_36139(rgbColor));
	}

	public static class_5250 noModifiers(class_5250 text) {
		return text.method_10862(
			text.method_10866()
				.method_10982(false)
				.method_10978(false)
				.method_36140(false)
				.method_36141(false)
				.method_30938(false)
		);
	}
}
