package io.github.xrickastley.sevenelements.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2232;
import net.minecraft.class_2561;
import net.minecraft.class_3002;

public class BossBarCommand {
	public static void register(CommandDispatcher<class_2168> dispatcher) {
		dispatcher.register(
			class_2170
				.method_9247("bossbar")
				.requires(cs -> cs.method_9259(2))
				.then(
					class_2170
						.method_9247("set")
						.then(
							class_2170
								.method_9244("id", class_2232.method_9441())
								.suggests(net.minecraft.class_3019.field_13482)
								.then(
									class_2170
										.method_9247("entity")
										.then(
											class_2170
												.method_9244("entity", class_2186.method_9309())
												.executes(c -> BossBarCommand.setEntity(c, net.minecraft.class_3019.method_13054(c)))
										)
								)
						)
				)
				.then(
					class_2170
						.method_9247("get")
						.then(
							class_2170
								.method_9244("id", class_2232.method_9441())
								.suggests(net.minecraft.class_3019.field_13482)
								.then(
									class_2170
										.method_9247("entity")
										.executes(c -> BossBarCommand.getEntity(c, net.minecraft.class_3019.method_13054(c)))
								)
						)
				)
		);
	}

	private static int setEntity(CommandContext<class_2168> context, class_3002 bossBar) throws CommandSyntaxException {
		final class_1297 entity = class_2186.method_9313(context, "entity");

		if (!(entity instanceof final class_1309 target)) {
			context
				.getSource()
				.method_9213(class_2561.method_43469("commands.element.failed.entity", entity.method_5476()).method_27692(class_124.field_1061));

			return 0;
		}

		bossBar.sevenelements$setEntity(target);

		context
			.getSource()
			.method_9226(() -> class_2561.method_43469("commands.bossbar.set.entity.success", bossBar.method_12965(), target.method_5476()), true);

		return 1;
	}

	private static int getEntity(CommandContext<class_2168> context, class_3002 bossBar) throws CommandSyntaxException {
		final class_1309 entity = bossBar.sevenelements$getEntity();

		if (entity != null && entity.method_29504()) bossBar.sevenelements$setEntity(null);

		context
			.getSource()
			.method_9226(
				() -> entity != null
					? class_2561.method_43469("commands.bossbar.get.entity.success", bossBar.method_12965(), entity.method_5476())
					: class_2561.method_43469("commands.bossbar.get.entity.none", bossBar.method_12965()),
				true
			);

		return entity != null ? 1 : 0;
	}
}
