package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.ModifyReturnValue;
import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;

import java.util.function.Consumer;
import net.minecraft.class_10712;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_9299;
import net.minecraft.class_9322;
import net.minecraft.class_9331;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.component.ElementalInfusionComponent;
import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.factory.SevenElementsComponents;
import io.github.xrickastley.sevenelements.util.TextHelper;

// Prioritized since Frozen **MUST** disable using items.
@Mixin(value = class_1799.class, priority = Integer.MIN_VALUE)
public abstract class ItemStackMixin implements class_9322 {
	@Shadow
	public abstract class_1792 getItem();

	@Shadow
	public abstract <T extends class_9299> void appendComponentTooltip(class_9331<T> componentType, class_1792.class_9635 context, class_10712 displayComponent, Consumer<class_2561> textConsumer, class_1836 type);

	@WrapOperation(
		method = "use",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/item/Item;use(Lnet/minecraft/world/World;Lnet/minecraft/entity/player/PlayerEntity;Lnet/minecraft/util/Hand;)Lnet/minecraft/util/ActionResult;"
		)
	)
	private class_1269 frozenPreventsItemUse(class_1792 instance, class_1937 world, class_1657 user, class_1268 hand, Operation<class_1269> original) {
		return user.method_6059(SevenElementsStatusEffects.FROZEN)
			? class_1269.field_5814
			: original.call(instance, world, user, hand);
	}

	@ModifyReturnValue(
		method = "getName",
		at = @At("RETURN")
	)
	private class_2561 modifyName(class_2561 original) {
		final @Nullable ElementalInfusionComponent component = this.method_58694(SevenElementsComponents.ELEMENTAL_INFUSION_COMPONENT);

		if (component == null || !component.hasElementalInfusion()) return original;

		final Element element = component.getElement();

		return class_2561.method_43473()
			.method_10852(original)
			.method_10852(TextHelper.noModifiers(TextHelper.color(" [" + element.getString() + "]", element.getDamageColor())));
	}

	@Inject(
		method = "appendTooltip",
		at = @At(
			value = "INVOKE",
			target = "Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V",
			ordinal = 6
		)
	)
	private void addInfusionData(class_1792.class_9635 context, class_10712 displayComponent, @Nullable class_1657 player, class_1836 type, Consumer<class_2561> textConsumer, CallbackInfo ci) {
		this.appendComponentTooltip(SevenElementsComponents.ELEMENTAL_INFUSION_COMPONENT, context, displayComponent, textConsumer, type);
	}
}
