package io.github.xrickastley.sevenelements.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import com.llamalad7.mixinextras.sugar.Local;
import com.llamalad7.mixinextras.sugar.Share;
import com.llamalad7.mixinextras.sugar.ref.LocalRef;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.class_1282;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_3218;
import net.minecraft.class_3545;
import net.minecraft.class_6880;
import net.minecraft.class_8103;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import io.github.xrickastley.sevenelements.component.ElementComponent;
import io.github.xrickastley.sevenelements.component.ElementComponentImpl;
import io.github.xrickastley.sevenelements.effect.ElementalStatusEffect;
import io.github.xrickastley.sevenelements.effect.SevenElementsStatusEffects;
import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplications;
import io.github.xrickastley.sevenelements.element.ElementalDamageSource;
import io.github.xrickastley.sevenelements.element.InternalCooldownContext;
import io.github.xrickastley.sevenelements.element.reaction.AdditiveElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.AmplifyingElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReaction;
import io.github.xrickastley.sevenelements.element.reaction.ElementalReactions;
import io.github.xrickastley.sevenelements.factory.SevenElementsAttributes;
import io.github.xrickastley.sevenelements.interfaces.ILivingEntity;
import io.github.xrickastley.sevenelements.util.ClassInstanceUtil;
import io.github.xrickastley.sevenelements.util.Functions;

@Mixin(value = class_1309.class, priority = Integer.MAX_VALUE - 1000)
public abstract class PrioritizedLivingEntityMixin
	extends class_1297
	implements ILivingEntity
{
	@Shadow
	protected float lastDamageTaken;
	@Shadow
	@Final
	private Map<class_6880<class_1291>, class_1293> activeStatusEffects;

	@Shadow
	public abstract boolean isDead();

	@Shadow
	public abstract boolean hasStatusEffect(class_6880<class_1291> effect);

	@Shadow
	public abstract boolean removeStatusEffect(class_6880<class_1291> effect);

	@Unique
	private List<ElementalReaction> sevenelements$reactions = new ArrayList<>();
	@Unique
	private @Nullable class_1297 sevenelements$plannedAttacker;
	@Unique
	private @Nullable class_1282 sevenelements$plannedDamageSource;

	public PrioritizedLivingEntityMixin(final class_1299<? extends class_1309> entityType, final class_1937 world) {
		super(entityType, world);

		throw new AssertionError();
	}

	@Unique
	@Override
	public @Nullable class_1297 sevenelements$getPlannedAttacker() {
		return this.sevenelements$plannedAttacker;
	}

	@Unique
	@Override
	public @Nullable class_1282 sevenelements$getPlannedDamageSource() {
		return this.sevenelements$plannedDamageSource;
	}

	@Inject(
		method = "canHaveStatusEffect",
		at = @At("HEAD"),
		cancellable = true,
		order = Integer.MIN_VALUE // Frozen and Cryo **must** persist while their respective elements are applied.
	)
	private void forceElementEffects(class_1293 effect, CallbackInfoReturnable<Boolean> cir) {
		if (ElementalStatusEffect.isElementalEffect(effect.method_5579())) cir.setReturnValue(true);
	}

	@Inject(
		method = "removeStatusEffectInternal",
		at = @At("HEAD"),
		cancellable = true,
		order = Integer.MIN_VALUE // Frozen and Cryo **must** persist while their respective elements are applied.
	)
	private void preventElementEffectRemoval(class_6880<class_1291> effect, CallbackInfoReturnable<class_1293> cir) {
		if (this.isDead() || !ElementalStatusEffect.isElementalEffect(effect)) return;

		final ElementalStatusEffect elementEffect = (ElementalStatusEffect) effect.comp_349();
		final ElementComponent component = ElementComponent.KEY.get(this);

		if (component.hasElementalApplication(elementEffect.getElement())) cir.setReturnValue(null);
	}

	@Inject(
		method = "onDeath",
		at = @At(
			value = "INVOKE",
			target = "Lnet/minecraft/entity/LivingEntity;setPose(Lnet/minecraft/entity/EntityPose;)V"
		)
	)
	private void removeForcedEffectsOnDeath(class_1282 damageSource, CallbackInfo ci) {
		ElementalStatusEffect
			.getElementEffects()
			.forEach(this::removeStatusEffect);
	}

	@Inject(
		method = "tick",
		at = @At("HEAD")
	)
	private void removeExpiredElementEffects(CallbackInfo ci) {
		final ElementComponent component = ElementComponent.KEY.get(this);

		ElementalStatusEffect
			.getElementEffects()
			.stream()
			.filter(this::hasStatusEffect)
			.filter(Predicate.not(
				Functions.composePredicate(class_6880::comp_349, ElementalStatusEffect.class::cast, ElementalStatusEffect::getElement, component::hasElementalApplication)
			))
			.forEach(this::removeStatusEffect);
	}

	@ModifyExpressionValue(
		method = "clearStatusEffects",
		at = @At(
			value = "INVOKE",
			target = "Lcom/google/common/collect/Maps;newHashMap(Ljava/util/Map;)Ljava/util/HashMap;",
			remap = false
		)
	)
	// Frozen and Cryo **must** persist while their respective elements are applied.
	private HashMap<class_6880<class_1291>, class_1293> persistElementEffectsOnClearStart(HashMap<class_6880<class_1291>, class_1293> value, @Share(value = "savedElements", namespace = "seven-elements") LocalRef<List<class_1293>> savedEffects) {
		if (this.isDead()) return value;

		final ElementComponent component = ElementComponent.KEY.get(this);

		savedEffects.set(new ArrayList<>());

		value
			.keySet()
			.stream()
			.filter(
				e -> ElementalStatusEffect
					.asElementEffect(e)
					.map(Functions.compose(ElementalStatusEffect::getElement, component::hasElementalApplication, b -> !b))
					.orElse(false)
			)
			.peek(Functions.composeConsumer(value::get, savedEffects.get()::add))
			.forEach(value::remove);

		return value;
	}

	@Inject(
		method = "clearStatusEffects",
		at = @At(
			value = "RETURN",
			ordinal = 2
		),
		order = Integer.MIN_VALUE // Frozen and Cryo **must** persist while their respective elements are applied.
	)
	private void persistElementEffectsOnClearEnd(CallbackInfoReturnable<Boolean> cir, @Share(value = "savedElements", namespace = "seven-elements") LocalRef<List<class_1293>> savedEffects) {
		for (final class_1293 effect : savedEffects.get())
			this.activeStatusEffects.put(effect.method_5579(), effect);
	}

	@Inject(
		method = "damage",
		at = @At("HEAD"),
		order = Integer.MIN_VALUE // The planned attacker should be set as early as possible.
	)
	private void setPlannedAttacker(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
		this.sevenelements$plannedAttacker = source.method_5529();
		this.sevenelements$plannedDamageSource = source;
	}

	@Inject(
		method = "damage",
		at = @At("HEAD"),
		cancellable = true,
		order = Integer.MIN_VALUE
	)
	private void preventDamageWhenFrozen(class_3218 world, class_1282 source, float amount, CallbackInfoReturnable<Boolean> cir) {
		if (source.method_5529() instanceof final class_1309 entity && entity.method_6059(SevenElementsStatusEffects.FROZEN))
			cir.setReturnValue(false);
	}

	@ModifyVariable(
		method = "damage",
		at = @At("HEAD"),
		argsOnly = true,
		order = Integer.MIN_VALUE // Infusions need to be considered before other DMG effects.
	)
	private class_1282 applyElementalInfusions(class_1282 source) {
		return ElementComponent.applyElementalInfusions(source, (class_1309)(class_1297) this);
	}

	@ModifyVariable(
		method = "damage",
		at = @At("HEAD"),
		argsOnly = true,
		order = Integer.MIN_VALUE // Additive DMG Bonus is a Base DMG multiplier, should be applied ASAP.
	)
	private float applyDMGModifiers(float amount, @Local(argsOnly = true) class_1282 source, @Local(argsOnly = true) class_3218 world) {
		final boolean fireResistance = source.method_48789(class_8103.field_42246) && this.hasStatusEffect(class_1294.field_5918);
		final boolean damageCooldown = this.field_6008 > 10.0F && !source.method_48789(class_8103.field_42969) && amount <= this.lastDamageTaken;

		// do **not** apply an element **if** DMG cannot be applied.
		if (this.method_5655() || this.method_73183().method_8608() || this.isDead() || fireResistance || damageCooldown) return amount;

		final ElementalDamageSource eds = source instanceof final ElementalDamageSource eds2
			? eds2
			: new ElementalDamageSource(source, ElementalApplications.gaugeUnits((class_1309)(class_1297) this, Element.PHYSICAL, 0.00), InternalCooldownContext.ofNone(source.method_5529()));

		final ElementComponent component = ElementComponent.KEY.get(this);
		this.sevenelements$reactions = new ArrayList<>(component.applyFromDamageSource(eds));

		final @Nullable ElementalReaction lastReaction = this.sevenelements$reactions.isEmpty()
			? null
			: this.sevenelements$reactions.get(this.sevenelements$reactions.size() - 1);

		final boolean doShatter = !this.sevenelements$reactions.contains(ElementalReactions.GEO_SHATTER)
			&& !this.sevenelements$reactions.contains(ElementalReactions.SHATTER)
			&& ElementalReactions.SHATTER.isTriggerable(this)
			&& (lastReaction == null || !lastReaction.preventsReaction(ElementalReactions.SHATTER));

		if (doShatter) {
			this.sevenelements$reactions.add(ElementalReactions.SHATTER);
			((ElementComponentImpl) component).setLastReaction(new class_3545<>(ElementalReactions.SHATTER, this.method_73183().method_8510()));

			ElementalReactions.SHATTER.trigger((class_1309)(class_1297) this, ClassInstanceUtil.castOrNull(source.method_5529(), class_1309.class));
		}

		float additive = this.sevenelements$reactions != null && !this.sevenelements$reactions.isEmpty()
			? Math.max(
				this.sevenelements$reactions
					.stream()
					.filter(reaction -> reaction instanceof AdditiveElementalReaction)
					.map(reaction -> ((AdditiveElementalReaction) reaction))
					.reduce(0.0f, (acc, reaction) -> acc + (float) reaction.getDamageBonus(world), Float::sum),
				0.0f
			)
			: 0.0f;

		return SevenElementsAttributes.modifyDamage((class_1309)(class_1297) this, eds, amount + additive);
	}

	@ModifyVariable(
		method = "modifyAppliedDamage",
		at = @At(
			value = "TAIL",
			shift = At.Shift.BEFORE
		),
		argsOnly = true,
		order = Integer.MAX_VALUE // Amplifying DMG Bonus is a Total DMG multiplier, should be applied as late as possible.
	)
	private float applyReactionAmplifiers(float amount, @Local(argsOnly = true) class_1282 source) {
		double amplifier = this.sevenelements$reactions != null && !this.sevenelements$reactions.isEmpty()
			? Math.max(
				this.sevenelements$reactions
					.stream()
					.filter(reaction -> reaction instanceof AmplifyingElementalReaction)
					.map(reaction -> ((AmplifyingElementalReaction) reaction))
					.reduce(0.0, (acc, reaction) -> acc + reaction.getAmplifier(), Double::sum),
				1.0
			)
			: 1.0;

		return amount * (float) amplifier;
	}
}
