
package io.github.xrickastley.sevenelements.mixin.client;
import com.mojang.blaze3d.buffers.GpuBufferSlice;

import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector4f;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import io.github.xrickastley.sevenelements.events.WorldRenderEnd;
import io.github.xrickastley.sevenelements.util.polyfill.rendering.WorldRenderContext;
import io.github.xrickastley.sevenelements.util.polyfill.rendering.WorldRenderContextImpl;
import io.github.xrickastley.sevenelements.util.polyfill.rendering.WorldRendererHooks;
import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_9779;
import net.minecraft.class_9922;

@Mixin(class_761.class)
public class WorldRendererMixin implements WorldRendererHooks {
	@Shadow
	@Nullable
	private class_638 world;

	@Unique
	private final WorldRenderContextImpl sevenelements$worldRenderContext = new WorldRenderContextImpl();

	@Override
	@Unique
	public WorldRenderContext sevenelements$getWorldRenderContext() {
		return this.sevenelements$worldRenderContext;
	}

	@Inject(
		method = "render",
		at = @At("HEAD")
	)
	private void beforeRender(class_9922 allocator, class_9779 tickCounter, boolean renderBlockOutline, class_4184 camera, Matrix4f positionMatrix, Matrix4f matrix4f, Matrix4f projectionMatrix, GpuBufferSlice fogBuffer, Vector4f fogColor, boolean renderSky, CallbackInfo ci) {
		this.sevenelements$worldRenderContext
			.prepare(((class_761)(Object) this), tickCounter, camera, world);
	}

	@Inject(
		method = "render",
		at = @At("RETURN")
	)
	private void afterRender(CallbackInfo ci) {
		WorldRenderEnd.EVENT.invoker().onWorldRenderEnd(this.sevenelements$worldRenderContext);
	}
}
