package io.github.xrickastley.sevenelements.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_10209;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1541;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1927;
import net.minecraft.class_1928;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3610;
import net.minecraft.class_3695;
import net.minecraft.class_3959;
import net.minecraft.class_3959.class_242;
import net.minecraft.class_3959.class_3960;
import net.minecraft.class_4770;
import net.minecraft.class_5134;
import net.minecraft.class_5361;
import net.minecraft.class_5362;
import net.minecraft.class_5712;
import org.jetbrains.annotations.Nullable;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;

/**
 * A class for explosions that don't damage entities.
 */
public class NonEntityDamagingExplosion implements class_1927 {
	private static final class_5362 DEFAULT_BEHAVIOR = new class_5362();
	private final boolean createFire;
	private final class_1927.class_4179 destructionType;
	private final class_3218 world;
	private final class_243 pos;
	private final @Nullable class_1297 entity;
	private final float power;
	private final class_5362 behavior;
	private final List<class_1297> affectedEntities = new ArrayList<>();
	private final Map<class_1657, class_243> knockbackByPlayer = new HashMap<>();

	public NonEntityDamagingExplosion(class_3218 world, @Nullable class_1297 entity, @Nullable class_5362 behavior, class_243 pos, float power, boolean createFire, class_1927.class_4179 destructionType) {
		this.world = world;
		this.entity = entity;
		this.power = power;
		this.pos = pos;
		this.createFire = createFire;
		this.destructionType = destructionType;
		this.behavior = behavior == null ? this.makeBehavior(entity) : behavior;
	}

	private class_5362 makeBehavior(@Nullable class_1297 entity) {
		return (class_5362)(entity == null ? DEFAULT_BEHAVIOR : new class_5361(entity));
	}

	public static float calculateReceivedDamage(class_243 pos, class_1297 entity) {
		class_238 box = entity.method_5829();
		double d = 1.0 / ((box.field_1320 - box.field_1323) * 2.0 + 1.0);
		double e = 1.0 / ((box.field_1325 - box.field_1322) * 2.0 + 1.0);
		double f = 1.0 / ((box.field_1324 - box.field_1321) * 2.0 + 1.0);
		double g = (1.0 - Math.floor(1.0 / d) * d) / 2.0;
		double h = (1.0 - Math.floor(1.0 / f) * f) / 2.0;
		if (!(d < 0.0) && !(e < 0.0) && !(f < 0.0)) {
			int i = 0;
			int j = 0;

			for(double k = 0.0; k <= 1.0; k += d) {
				for(double l = 0.0; l <= 1.0; l += e) {
					for(double m = 0.0; m <= 1.0; m += f) {
						double n = class_3532.method_16436(k, box.field_1323, box.field_1320);
						double o = class_3532.method_16436(l, box.field_1322, box.field_1325);
						double p = class_3532.method_16436(m, box.field_1321, box.field_1324);
						class_243 vec3d = new class_243(n + g, o, p + h);
						if (entity.method_73183().method_17742(new class_3959(vec3d, pos, class_3960.field_17558, class_242.field_1348, entity)).method_17783() == class_239.class_240.field_1333) {
							++i;
						}

						++j;
					}
				}
			}

			return (float)i / (float)j;
		} else {
			return 0.0F;
		}
	}

	public float method_55107() {
		return this.power;
	}

	public class_243 method_55109() {
		return this.pos;
	}

	@SuppressWarnings("unused")
	private List<class_2338> getBlocksToDestroy() {
		Set<class_2338> set = new HashSet<>();

		for(int j = 0; j < 16; ++j) {
			for(int k = 0; k < 16; ++k) {
				for(int l = 0; l < 16; ++l) {
					if (j == 0 || j == 15 || k == 0 || k == 15 || l == 0 || l == 15) {
						double d = (double)((float)j / 15.0F * 2.0F - 1.0F);
						double e = (double)((float)k / 15.0F * 2.0F - 1.0F);
						double f = (double)((float)l / 15.0F * 2.0F - 1.0F);
						double g = Math.sqrt(d * d + e * e + f * f);
						d /= g;
						e /= g;
						f /= g;
						float h = this.power * (0.7F + this.world.field_9229.method_43057() * 0.6F);
						double m = this.pos.field_1352;
						double n = this.pos.field_1351;
						double o = this.pos.field_1350;

						for(float p = 0.3F; h > 0.0F; h -= 0.22500001F) {
							class_2338 blockPos = class_2338.method_49637(m, n, o);
							class_2680 blockState = this.world.method_8320(blockPos);
							class_3610 fluidState = this.world.method_8316(blockPos);
							if (!this.world.method_24794(blockPos)) {
								break;
							}

							Optional<Float> optional = this.behavior.method_29555(this, this.world, blockPos, blockState, fluidState);
							if (optional.isPresent()) {
								h -= ((Float)optional.get() + 0.3F) * 0.3F;
							}

							if (h > 0.0F && this.behavior.method_29554(this, this.world, blockPos, blockState, h)) {
								set.add(blockPos);
							}

							m += d * 0.30000001192092896;
							n += e * 0.30000001192092896;
							o += f * 0.30000001192092896;
						}
					}
				}
			}
		}

		return new ObjectArrayList<>(set);
	}

	private void damageEntities() {
		float f = this.power * 2.0F;
		int i = class_3532.method_15357(this.pos.field_1352 - (double)f - 1.0);
		int j = class_3532.method_15357(this.pos.field_1352 + (double)f + 1.0);
		int k = class_3532.method_15357(this.pos.field_1351 - (double)f - 1.0);
		int l = class_3532.method_15357(this.pos.field_1351 + (double)f + 1.0);
		int m = class_3532.method_15357(this.pos.field_1350 - (double)f - 1.0);
		int n = class_3532.method_15357(this.pos.field_1350 + (double)f + 1.0);
		List<class_1297> list = this.world.method_8335(this.entity, new class_238((double)i, (double)k, (double)m, (double)j, (double)l, (double)n));
		Iterator<class_1297> var9 = list.iterator();

		while (true) {
			class_1297 entity;
			double d, e, g, h, o;

			do {
				do {
					do {
						if (!var9.hasNext()) return;

						entity = var9.next();
					} while (entity.method_5659(this));

					d = Math.sqrt(entity.method_5707(this.pos)) / (double) f;
				} while (!(d <= 1.0));

				e = entity.method_23317() - this.pos.field_1352;
				g = (entity instanceof class_1541 ? entity.method_23318() : entity.method_23320()) - this.pos.field_1351;
				h = entity.method_23321() - this.pos.field_1350;
				o = Math.sqrt(e * e + g * g + h * h);
			} while (o == 0.0);

			e /= o;
			g /= o;
			h /= o;
			boolean bl = this.behavior.method_55504(this, entity);
			float p = this.behavior.method_57007(entity);
			float q = !bl && p == 0.0F ? 0.0F : calculateReceivedDamage(this.pos, entity);



			double r = (1.0 - d) * (double) q * (double) p;
			double s = entity instanceof class_1309 livingEntity
				? r * (1.0 - livingEntity.method_45325(class_5134.field_51580))
				: r;

			e *= s;
			g *= s;
			h *= s;
			class_243 vec3d = new class_243(e, g, h);
			entity.method_18799(entity.method_18798().method_1019(vec3d));
			if (entity instanceof class_1657 playerEntity) {
				if (!playerEntity.method_7325() && (!playerEntity.method_68878() || !playerEntity.method_31549().field_7479)) {
					this.knockbackByPlayer.put(playerEntity, vec3d);
				}
			}

			entity.method_56918(this.entity);
			this.affectedEntities.add(entity);
		}
	}

	private void destroyBlocks(List<class_2338> positions) {
		List<DroppedItem> list = new ArrayList<>();
		class_156.method_43028(positions, this.world.field_9229);
		Iterator<class_2338> posIterator = positions.iterator();

		while(posIterator.hasNext()) {
			class_2338 blockPos = (class_2338)posIterator.next();
			this.world.method_8320(blockPos).method_55225(this.world, blockPos, this, (item, pos) -> {
				addDroppedItem(list, item, pos);
			});
		}

		Iterator<DroppedItem> droppedItemIterator = list.iterator();

		while(droppedItemIterator.hasNext()) {
			final DroppedItem droppedItem = droppedItemIterator.next();
			class_2248.method_9577(this.world, droppedItem.pos, droppedItem.item);
		}

	}

	private void createFire(List<class_2338> positions) {
		Iterator<class_2338> var2 = positions.iterator();

		while(var2.hasNext()) {
			class_2338 blockPos = (class_2338)var2.next();
			if (this.world.field_9229.method_43048(3) == 0 && this.world.method_8320(blockPos).method_26215() && this.world.method_8320(blockPos.method_10074()).method_26216()) {
				this.world.method_8501(blockPos, class_4770.method_24416(this.world, blockPos));
			}
		}

	}

	public void explode() {
		this.world.method_43275(this.entity, class_5712.field_28178, this.pos);
		List<class_2338> list = this.getBlocksToDestroy();
		this.damageEntities();
		if (this.shouldDestroyBlocks()) {
			class_3695 profiler = class_10209.method_64146();
			profiler.method_15396("explosion_blocks");
			this.destroyBlocks(list);
			profiler.method_15407();
		}

		if (this.createFire) {
			this.createFire(list);
		}

	}

	private static void addDroppedItem(List<DroppedItem> droppedItemsOut, class_1799 item, class_2338 pos) {
		Iterator<DroppedItem> var3 = droppedItemsOut.iterator();

		do {
			if (!var3.hasNext()) {
				droppedItemsOut.add(new DroppedItem(pos, item));
				return;
			}

			DroppedItem droppedItem = (DroppedItem)var3.next();
			droppedItem.merge(item);
		} while(!item.method_7960());

	}

	private boolean shouldDestroyBlocks() {
		return this.destructionType != class_4179.field_40878;
	}

	public Map<class_1657, class_243> getKnockbackByPlayer() {
		return this.knockbackByPlayer;
	}

	public class_3218 method_64504() {
		return this.world;
	}

	public @Nullable class_1309 method_8347() {
		return class_1927.method_55110(this.entity);
	}

	public @Nullable class_1297 method_46406() {
		return this.entity;
	}

	public class_1927.class_4179 method_55111() {
		return this.destructionType;
	}

	public List<class_1297> getAffectedEntities() {
		return Collections.unmodifiableList(affectedEntities);
	}

	public boolean method_60274() {
		if (this.destructionType != class_4179.field_47331) {
			return false;
		} else {
			return this.entity != null && this.entity.method_5864() == class_1299.field_49075 ? this.world.method_64395().method_8355(class_1928.field_19388) : true;
		}
	}

	public boolean method_61722() {
		boolean bl = this.world.method_64395().method_8355(class_1928.field_19388);
		boolean bl2 = this.entity == null || !this.entity.method_5799();
		boolean bl3 = this.entity == null || this.entity.method_5864() != class_1299.field_49075 && this.entity.method_5864() != class_1299.field_47243;
		if (bl) {
			return bl2 && bl3;
		} else {
			return this.destructionType.method_61723() && bl2 && bl3;
		}
	}

	public boolean isSmall() {
		return this.power < 2.0F || !this.shouldDestroyBlocks();
	}

	static class DroppedItem {
		final class_2338 pos;
		class_1799 item;

		DroppedItem(class_2338 pos, class_1799 item) {
			this.pos = pos;
			this.item = item;
		}

		public void merge(class_1799 other) {
			if (class_1542.method_24017(this.item, other)) {
				this.item = class_1542.method_24018(this.item, other, 16);
			}
		}
	}
}
