/*
 * Copyright (c) 2016, 2017, 2018, 2019 FabricMC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Polyfilled in SevenElements and Modified by xrickastley.

package io.github.xrickastley.sevenelements.util.polyfill.rendering;

import net.minecraft.class_4184;
import net.minecraft.class_638;
import net.minecraft.class_761;
import net.minecraft.class_9779;

public final class WorldRenderContextImpl implements WorldRenderContext {
	private class_761 worldRenderer;
	private class_9779 tickCounter;
	private class_4184 camera;
	private class_638 world;

	public void prepare(
			class_761 worldRenderer,
			class_9779 tickCounter,
			class_4184 camera,
			class_638 world
	) {
		this.worldRenderer = worldRenderer;
		this.tickCounter = tickCounter;
		this.camera = camera;
		this.world = world;
	}

	@Override
	public class_761 worldRenderer() {
		return worldRenderer;
	}

	@Override
	public class_9779 tickCounter() {
		return this.tickCounter;
	}

	@Override
	public class_4184 camera() {
		return camera;
	}

	@Override
	public class_638 world() {
		return world;
	}
}