package io.github.xrickastley.sevenelements.renderer.genshin;

import com.mojang.blaze3d.systems.RenderSystem;

import org.joml.Matrix4f;

import io.github.xrickastley.sevenelements.element.Element;
import io.github.xrickastley.sevenelements.element.ElementalApplication;
import io.github.xrickastley.sevenelements.util.Ease;
import net.minecraft.class_10142;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_3532;
import net.minecraft.class_4184;
import net.minecraft.class_4587;

public final class ElementEntry {
	private static final float BLINK_SECONDS = 1.5f;
	private static final float BLINK_COUNT = 3;

	private final Element element;
	private final double secondsLeft;
	private final long appliedAt;
	private final float tickDelta;

	public ElementEntry(Element element, double secondsLeft, long appliedAt, float tickDelta) {
		this.element = element;
		this.secondsLeft = secondsLeft;
		this.appliedAt = appliedAt;
		this.tickDelta = tickDelta;
	}

	public static ElementEntry of(ElementalApplication application, float tickDelta) {
		return new ElementEntry(application.getElement(), (application.getRemainingTicks() - tickDelta) / 20.0, application.getAppliedAt(), tickDelta);
	}

	public Element getElement() {
		return element;
	}

	private long getAppliedTicks(final class_1297 entity) {
		return entity.method_37908().method_8510() - this.appliedAt;
	}

	public void render(final class_1309 entity, final class_4587 matrixStack, final class_4184 camera, final float offset) {
		final float blinkInterval = ElementEntry.BLINK_SECONDS / ElementEntry.BLINK_COUNT;
		final float intervalSplit = blinkInterval / 2f;

		matrixStack.method_22903();
		matrixStack.method_22904(0, entity.method_5829().method_17940() * 1.1, 0);
		matrixStack.method_34425(new Matrix4f().rotation(camera.method_23767()));
		matrixStack.method_22905(0.50F, 0.50F, 0.50F);

		final float alpha = (float) (this.secondsLeft <= (BLINK_SECONDS + intervalSplit)
			? this.secondsLeft % blinkInterval <= intervalSplit
				? class_3532.method_16436((this.secondsLeft % blinkInterval) / intervalSplit, 0, 1)
				: class_3532.method_16436(((this.secondsLeft % blinkInterval) - 0.25) / intervalSplit, 1, 0)
			: 1);

		RenderSystem.setShader(class_10142.field_53879);
		RenderSystem.setShaderTexture(0, this.element.getTexture());
		RenderSystem.setShaderColor(1f, 1f, 1f, alpha);

		RenderSystem.enableBlend();
		RenderSystem.defaultBlendFunc();
		RenderSystem.disableCull();
		RenderSystem.enableDepthTest();

		this.draw(matrixStack, camera, offset);

		if (this.getAppliedTicks(entity) <= 5) {
			final double animationProgress = Ease.LINEAR.applyLerpProgress(this.getAppliedTicks(entity) + tickDelta, 1, 6);
			final float scale2 = (float) (animationProgress * 2);
			final float alpha2 = (float) (1 - (animationProgress * 0.5));

			matrixStack.method_22905(scale2, scale2, scale2);

			RenderSystem.setShaderColor(1f, 1f, 1f, alpha2);

			this.draw(matrixStack, camera, offset);
		}

		matrixStack.method_22909();

		RenderSystem.setShaderColor(1f, 1f, 1f, 1f);
	}

	private void draw(final class_4587 matrixStack, final class_4184 camera, final float offset) {
		final class_289 tessellator = class_289.method_1348();
		final class_287 buffer = tessellator.method_60827(class_293.class_5596.field_27382, class_290.field_1585);

		final float finalXOffset = -0.5f + offset;

		final Matrix4f positionMatrix = matrixStack.method_23760().method_23761();

		buffer.method_22918(positionMatrix, 0 + finalXOffset, 0, 0).method_22913(0f, 1f);
		buffer.method_22918(positionMatrix, 1 + finalXOffset, 0, 0).method_22913(1f, 1f);
		buffer.method_22918(positionMatrix, 1 + finalXOffset, 1, 0).method_22913(1f, 0f);
		buffer.method_22918(positionMatrix, 0 + finalXOffset, 1, 0).method_22913(0f, 0f);

		class_286.method_43433(buffer.method_60800());
	}
}
